/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Matcher;
import org.omegat.util.Log;
import org.omegat.util.PatternConsts;

public class XMLWriter
extends Writer {
    private StringWriter writer;
    private BufferedWriter realWriter;
    private String XML_HEADER;
    private final int minHeaderedBufferSize = 4096;
    private final int maxBufferSize = 65536;
    private boolean signalClosing = false;
    private boolean signalAlreadyFlushed = false;

    public XMLWriter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this.XML_HEADER = string == null ? "<?xml version=\"1.0\"?>" : "<?xml version=\"1.0\" encoding=\"" + string + "\"?>";
        this.writer = new StringWriter();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = string == null ? new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8") : new OutputStreamWriter((OutputStream)fileOutputStream, string);
        this.realWriter = new BufferedWriter(outputStreamWriter);
    }

    public void close() throws IOException {
        this.signalClosing = true;
        this.flush();
        this.realWriter.close();
    }

    public void flush() throws IOException {
        StringBuffer stringBuffer = this.writer.getBuffer();
        if (this.signalAlreadyFlushed) {
            this.realWriter.write(stringBuffer.toString());
            stringBuffer.setLength(0);
        } else if (this.signalClosing || stringBuffer.length() >= 4096) {
            String string;
            this.signalAlreadyFlushed = true;
            Matcher matcher = PatternConsts.XML_HEADER.matcher(stringBuffer);
            if (matcher.find()) {
                string = matcher.replaceFirst(this.XML_HEADER);
            } else {
                Log.log("Shouldn't happen! XMLWriter: XML File does not contain XML header:\n" + stringBuffer.substring(0, Math.min(stringBuffer.length(), 80)));
                this.realWriter.write(this.XML_HEADER);
                string = stringBuffer.toString();
            }
            this.realWriter.write(string);
            stringBuffer.setLength(0);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.writer.write(cArray, n, n2);
        if (this.writer.getBuffer().length() >= 65536) {
            this.flush();
        }
    }
}

