/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import org.omegat.core.Core;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.util.Token;

public class ViewLabel
extends LabelView {
    public ViewLabel(Element element) {
        super(element);
    }

    public void paint(Graphics graphics, Shape shape) {
        super.paint(graphics, shape);
        if (!(this.getElement().getDocument() instanceof Document3)) {
            return;
        }
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        Document3 document3 = (Document3)this.getElement().getDocument();
        int n3 = -1;
        for (int i = 0; i < document3.controller.m_docSegList.length; ++i) {
            if (!document3.controller.m_docSegList[i].isInsideSegment((n + n2) / 2)) continue;
            n3 = i;
            break;
        }
        if (n3 < 0) {
            return;
        }
        SegmentBuilder segmentBuilder = document3.controller.m_docSegList[n3];
        if ((n = Math.max(n, segmentBuilder.getStartSpellPosition())) < (n2 = Math.min(n2, segmentBuilder.getEndSpellPosition()))) {
            try {
                Token[] tokenArray;
                String string = document3.getText(n, n2 - n);
                for (Token token : tokenArray = Core.getTokenizer().tokenizeWordsForSpelling(string)) {
                    if (!document3.controller.spellCheckerThread.isIncorrect(string.substring(token.getOffset(), token.getOffset() + token.getLength()))) continue;
                    Rectangle rectangle = this.modelToView(n + token.getOffset(), shape, Position.Bias.Forward).getBounds();
                    Rectangle rectangle2 = this.modelToView(n + token.getOffset() + token.getLength(), shape, Position.Bias.Backward).getBounds();
                    Rectangle rectangle3 = new Rectangle();
                    rectangle3.x = rectangle.x;
                    rectangle3.y = rectangle.y;
                    rectangle3.width = rectangle2.x - rectangle.x;
                    rectangle3.height = rectangle.height;
                    this.paintJaggedLine(graphics, rectangle3, Color.red);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    protected void paintJaggedLine(Graphics graphics, Shape shape, Color color) {
        int n = (int)(shape.getBounds().getY() + shape.getBounds().getHeight() - 1.0);
        int n2 = (int)shape.getBounds().getX();
        int n3 = (int)(shape.getBounds().getX() + shape.getBounds().getWidth());
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        int n4 = 3;
        int n5 = 2;
        Shape shape2 = graphics.getClip();
        graphics.setClip(shape);
        for (int i = n2; i <= n3; i += n4 * 2) {
            graphics.drawArc(i + 0, n - n5, n4, n5, 0, 180);
            graphics.drawArc(i + n4, n - n5, n4, n5, 180, 181);
        }
        graphics.setClip(shape2);
        graphics.setColor(color2);
    }
}

