/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.exttrans;

import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.StringEntry;
import org.omegat.gui.common.EntryInfoPane;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.WikiGet;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleTranslateTextArea
extends EntryInfoPane<String> {
    protected static String GT_URL = "http://ajax.googleapis.com/ajax/services/language/translate?v=1.0&langpair=#sourceLang#|#targetLang#&q=";
    protected static String MARK_BEG = "{\"translatedText\":\"";
    protected static String MARK_END = "\"}";
    protected static Pattern RE_UNICODE = Pattern.compile("\\\\u([0-9A-Fa-f]{4})");
    protected static Pattern RE_HTML = Pattern.compile("&#([0-9]+);");

    public GoogleTranslateTextArea() {
        super(true);
        this.setEditable(false);
        String string = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_GoogleTranslate");
        Core.getMainWindow().addDockable(new DockableScrollPane("GOOGLE_TRANSLATE", string, this, true));
    }

    @Override
    protected void onProjectClose() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText("");
    }

    @Override
    protected void startSearchThread(StringEntry stringEntry) {
        UIThreadsUtil.mustBeSwingThread();
        if (Preferences.isPreference("allow_google_translate")) {
            new FindThread(stringEntry).start();
        } else {
            this.setText("");
        }
    }

    @Override
    protected void setFoundResult(String string) {
        UIThreadsUtil.mustBeSwingThread();
        this.setText(string != null ? string : "");
    }

    protected static String translate(String string, String string2, String string3) throws Exception {
        char c;
        String string4;
        Matcher matcher;
        String string5 = string.length() > 5000 ? string.substring(0, 4997) + "..." : string;
        String string6 = GT_URL.replace("#sourceLang#", string2).replace("#targetLang#", string3) + URLEncoder.encode(string5, "UTF-8");
        String string7 = WikiGet.getURL(string6);
        while ((matcher = RE_UNICODE.matcher(string7)).find()) {
            string4 = matcher.group();
            c = (char)Integer.parseInt(matcher.group(1), 16);
            string7 = string7.replace(string4, Character.toString(c));
        }
        string7 = string7.replace("&quot;", "&#34;");
        string7 = string7.replace("&nbsp;", "&#160;");
        string7 = string7.replace("&amp;", "&#38;");
        while ((matcher = RE_HTML.matcher(string7)).find()) {
            string4 = matcher.group();
            c = (char)Integer.parseInt(matcher.group(1));
            string7 = string7.replace(string4, Character.toString(c));
        }
        int n = string7.indexOf(MARK_BEG) + MARK_BEG.length();
        int n2 = string7.indexOf(MARK_END, n);
        String string8 = string7.substring(n, n2);
        return string8;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FindThread
    extends EntryInfoSearchThread<String> {
        private final String src;

        public FindThread(StringEntry stringEntry) {
            super(GoogleTranslateTextArea.this, stringEntry);
            this.src = stringEntry.getSrcText();
        }

        @Override
        protected String search() throws Exception {
            String string = Core.getProject().getProjectProperties().getSourceLanguage().getLanguageCode();
            String string2 = Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode();
            if (string == null || string2 == null) {
                return null;
            }
            return GoogleTranslateTextArea.translate(this.src, string, string2);
        }
    }
}

