/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.gui.common.EntryInfoPane;
import org.omegat.gui.glossary.FindGlossaryThread;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryManager;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.util.OStrings;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlossaryTextArea
extends EntryInfoPane<List<GlossaryEntry>> {
    protected final GlossaryManager manager = new GlossaryManager(this);
    protected StringEntry processedEntry;

    public GlossaryTextArea() {
        super(true);
        this.setEditable(false);
        String string = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Glossary");
        Core.getMainWindow().addDockable(new DockableScrollPane("GLOSSARY", string, this, true));
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
        this.manager.start();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.manager.stop();
    }

    @Override
    protected void startSearchThread(StringEntry stringEntry) {
        new FindGlossaryThread(this, stringEntry, this.manager).start();
    }

    public void refresh() {
        SourceTextEntry sourceTextEntry = Core.getEditor().getCurrentEntry();
        if (sourceTextEntry != null) {
            this.startSearchThread(sourceTextEntry.getStrEntry());
        }
    }

    @Override
    protected void setFoundResult(List<GlossaryEntry> list) {
        UIThreadsUtil.mustBeSwingThread();
        StringBuffer stringBuffer = new StringBuffer();
        for (GlossaryEntry glossaryEntry : list) {
            stringBuffer.append(glossaryEntry.getSrcText() + " = " + glossaryEntry.getLocText());
            if (glossaryEntry.getCommentText().length() > 0) {
                stringBuffer.append("\n" + glossaryEntry.getCommentText());
            }
            stringBuffer.append("\n\n");
        }
        this.setText(stringBuffer.toString());
    }

    public void clear() {
        this.setText("");
    }
}

