/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.CacheFileNames;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.ExcludePackageProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.AbstractTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicTranslationDictionary
extends AbstractTranslationDictionary
implements CacheFileNames {
    private static final Logger log = Logger.getLogger(DynamicTranslationDictionary.class);
    private static final File cacheFile = Pleiades.getResourceFile("translation-cache.properties.zip");
    private static final int TRACE_MAX = 30;
    private static final DynamicTranslationDictionary singleton = new DynamicTranslationDictionary();
    private PropertySet cacheProp;

    public static DynamicTranslationDictionary getInstance() {
        return singleton;
    }

    @Override
    protected boolean load() {
        this.cacheProp = new CachePropertySet();
        if (Pleiades.getPleiadesOption().isClean() || !cacheFile.exists()) {
            super.load();
            this.cacheProp.load(DynamicTranslationDictionary.validateExists("translation-multibytes-key.properties"));
        } else {
            try {
                this.cacheProp.load(cacheFile);
            }
            catch (RuntimeException e) {
                log.warn("\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5 %s \u306e\u7834\u640d\u3092\u691c\u51fa\u3002\u5fa9\u5143\u4e2d... - %s", cacheFile, e.toString());
                cacheFile.delete();
                this.cacheProp.clear();
                this.cacheProp.load(DynamicTranslationDictionary.validateExists("translation-multibytes-key.properties"));
            }
        }
        return true;
    }

    public void shutdown() {
        this.isLoadedDefault = true;
        if (Pleiades.getPleiadesOption().isClean() || !cacheFile.exists()) {
            this.cacheProp.store(cacheFile, "\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
        } else {
            PropertySet cachePropOld = new PropertySet(cacheFile);
            if (this.cacheProp.size() > cachePropOld.size()) {
                this.cacheProp.store(cacheFile, "\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
                log.info("\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u66f4\u65b0\u3057\u307e\u3057\u305f\u3002", new Object[0]);
            } else {
                log.info("\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306e\u66f4\u65b0\u306f\u3042\u308a\u307e\u305b\u3093\u3002", new Object[0]);
            }
        }
    }

    public String lookup(String enWithMnemonic, JointPoint jointPoint) {
        if (enWithMnemonic.equals("") || enWithMnemonic.contains("\u30fb") || Mnemonics.hasJaMnemonic(enWithMnemonic)) {
            return enWithMnemonic;
        }
        String en = Mnemonics.removeEnMnemonic(enWithMnemonic);
        if (this.cacheProp.containsValue(en.trim())) {
            return enWithMnemonic;
        }
        if (this.isNoTranslation(en, jointPoint)) {
            if (en.equals("Debug")) {
                return enWithMnemonic;
            }
            return this.convertMnemonicEnToJa(enWithMnemonic, en, en);
        }
        String ja = this.lookupInternal(en, jointPoint);
        ja = this.convertMnemonicEnToJa(enWithMnemonic, en, ja);
        return ja;
    }

    public String lookupIgnoreMnemonic(String en, JointPoint jointPoint) {
        if (this.isNoTranslation(en, jointPoint)) {
            return en;
        }
        String ja = this.lookupInternal(en, jointPoint);
        return ja;
    }

    public String lookupHelp(String en, JointPoint jointPoint) {
        return this.getValueForHelp(en);
    }

    protected String lookupInternal(String en, JointPoint jointPoint) {
        String ja = (String)this.cacheProp.get(en);
        if (ja != null) {
            if (ja.equals("")) {
                ja = en;
            }
        } else {
            ja = super.getValueByRegex(new TranslationString(en));
            if (ja == null) {
                if (en.length() != en.getBytes().length) {
                    ja = en;
                } else {
                    if (super.load()) {
                        log.debug("\u30ad\u30e3\u30c3\u30b7\u30e5\u306b\u306a\u3044\u305f\u3081\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9: " + Property.escapeKey(en), new Object[0]);
                    }
                    ja = this.getValue(en);
                }
                this.cacheProp.put(en, en.equals(ja) ? "" : ja);
            }
        }
        return ja;
    }

    @Override
    protected String getValueByRegex(TranslationString enTs) {
        return null;
    }

    protected String convertMnemonicEnToJa(String enWithMnemonic, String en, String ja) {
        if (Pleiades.getPleiadesOption().isNoMnemonic()) {
            return ja;
        }
        String jaWithMnemonic = Mnemonics.convertMnemonicEnToJa(enWithMnemonic, en, ja);
        return jaWithMnemonic;
    }

    protected boolean isNoTranslation(String en, JointPoint jointPoint) {
        PointCut pointCut;
        StackTraceElement[] stes = null;
        Set<String> noTransPathEntries = ExcludePackageProperties.getInstance().getPathEntries(en);
        if (noTransPathEntries != null) {
            stes = Thread.currentThread().getStackTrace();
            int i = 0;
            while (i < 30 && i < stes.length) {
                StackTraceElement ste = stes[i];
                String className = ste.getClassName();
                for (String noTransPath : noTransPathEntries) {
                    if (!className.startsWith(noTransPath)) continue;
                    return true;
                }
                ++i;
            }
        }
        if (jointPoint != null && (pointCut = AspectMapping.getInstance().getPointCut(jointPoint)) != null) {
            List<JointPoint> excludeTrace = pointCut.getExcludeTrace();
            List<JointPoint> includeTrace = pointCut.getIncludeTrace();
            if (excludeTrace.size() > 0) {
                if (stes == null) {
                    stes = Thread.currentThread().getStackTrace();
                }
                if (this.containsTrace(excludeTrace, stes)) {
                    return true;
                }
            }
            if (includeTrace.size() > 0) {
                if (stes == null) {
                    stes = Thread.currentThread().getStackTrace();
                }
                if (!this.containsTrace(includeTrace, stes)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean containsTrace(List<JointPoint> trace, StackTraceElement[] stes) {
        for (JointPoint jp : trace) {
            int i = 0;
            while (i < 30 && i < stes.length) {
                String methodName;
                StackTraceElement ste = stes[i];
                if (ste.getClassName().startsWith(jp.getClassName()) && ((methodName = jp.getMethodName()) == null || ste.getMethodName().equals(methodName))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static class CachePropertySet
    extends PropertySet {
        Set<String> values = new HashSet<String>();

        private CachePropertySet() {
        }

        public boolean containsValue(Object value) {
            return this.values.contains(value);
        }

        public String put(String key, String value) {
            this.values.add(value);
            return super.put(key, value);
        }
    }
}

