/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySet
extends HashMap<String, String>
implements Iterable<Property> {
    private final Logger log = Logger.getLogger(this.getClass());
    private static final String PROP_EXTENSION = ".properties";
    protected static final String ZIP_EXTENSION = ".zip";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public PropertySet() {
    }

    public PropertySet(String ... paths) {
        this.load(paths);
    }

    public PropertySet(File ... files) {
        this.load(files);
    }

    public PropertySet(Properties ... props) {
        Properties[] propertiesArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            Properties prop = propertiesArray[n2];
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                this.put((String)entry.getKey(), (String)entry.getValue());
            }
            ++n2;
        }
    }

    public PropertySet(PropertySet ... props) {
        PropertySet[] propertySetArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            PropertySet prop = propertySetArray[n2];
            this.putAll(prop);
            ++n2;
        }
    }

    public void load(String ... paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = Files.getFile(path);
            this.load(file);
            ++n2;
        }
    }

    public void load(File ... files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                Object[] fs = file.listFiles(Files.createFileFilter());
                Arrays.sort(fs);
                Object[] objectArray = fs;
                int n3 = fs.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object f = objectArray[n4];
                    String name = ((File)f).getName();
                    if (name.endsWith(PROP_EXTENSION) || name.endsWith(".properties.zip")) {
                        this.loadFile((File)f);
                    }
                    ++n4;
                }
            } else {
                this.loadFile(file);
            }
            ++n2;
        }
    }

    public void load(InputStream is) {
        try {
            this.loadInternal(is);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void loadRecursive(File ... dirs) {
        File[] fileArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            Object[] fs = dir.listFiles();
            Arrays.sort(fs);
            Object[] objectArray = fs;
            int n3 = fs.length;
            int n4 = 0;
            while (n4 < n3) {
                Object f = objectArray[n4];
                if (((File)f).isDirectory()) {
                    this.loadRecursive(new File[]{f});
                } else {
                    this.load(new File[]{f});
                }
                ++n4;
            }
            ++n2;
        }
    }

    public String put(Property p) {
        return this.put(p.key, p.value);
    }

    public List<String> store(String path, String comment) {
        File resourceFile = Files.getFile(path);
        return this.store(resourceFile, comment);
    }

    public List<String> store(File file, String comment) {
        List<String> list;
        long startTime = System.nanoTime();
        String fileName = file.getName();
        if (file.exists() && fileName.endsWith(PROP_EXTENSION)) {
            PropertySet old = new PropertySet();
            old.loadFileWithoutLog(file);
            if (old.equals(this)) {
                this.log.info("store \u66f4\u65b0\u306a\u3057   %6d \u30a8\u30f3\u30c8\u30ea\u30fc %-34s", this.size(), fileName);
                return null;
            }
        }
        LinkedList<String> headerList = new LinkedList<String>();
        headerList.add(this.saveConvertComment("\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306f Pleiades \u306b\u3088\u308a\u751f\u6210\u3055\u308c\u307e\u3057\u305f\u3002" + this.size() + " \u30a8\u30f3\u30c8\u30ea\u30fc\u3002"));
        headerList.add("####################################################################################################");
        headerList.add("# ");
        String[] stringArray = comment.split("\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            headerList.add("# " + this.saveConvertComment(s));
            ++n2;
        }
        headerList.add("# ");
        headerList.add("####################################################################################################");
        String header = StringUtils.join(headerList, (String)"\n");
        FilterOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            if (fileName.endsWith(".properties.zip")) {
                ZipOutputStream zos = new ZipOutputStream(os);
                zos.setLevel(1);
                zos.putNextEntry(new ZipEntry(fileName.replace(ZIP_EXTENSION, "")));
                os = zos;
            }
            List<String> keyList = this.store(os, header);
            this.log.info("store %4.3f \u79d2 - %6d \u30a8\u30f3\u30c8\u30ea\u30fc %s", (double)(System.nanoTime() - startTime) / 1.0E9, this.size(), fileName);
            list = keyList;
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(file.toString(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        return list;
    }

    @Override
    public Iterator<Property> iterator() {
        final Iterator it = this.entrySet().iterator();
        return new Iterator<Property>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Property next() {
                Map.Entry entry = (Map.Entry)it.next();
                return new Property((String)entry.getKey(), (String)entry.getValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected InputStream getInputStream(File file) throws IOException {
        FilterInputStream is = new BufferedInputStream(new FileInputStream(file));
        if (file.getName().endsWith(".properties.zip")) {
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            zis.getNextEntry();
            is = zis;
        }
        return is;
    }

    private void loadFile(File file) {
        long startTime = System.nanoTime();
        this.loadFileWithoutLog(file);
        this.log.info("load  %4.3f \u79d2 - %6d \u30a8\u30f3\u30c8\u30ea\u30fc %s", (double)(System.nanoTime() - startTime) / 1.0E9, this.size(), file.getName());
    }

    private void loadFileWithoutLog(File file) {
        InputStream is = null;
        try {
            is = this.getInputStream(file);
            if (is == null) {
                return;
            }
            try {
                this.loadInternal(is);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private void loadInternal(InputStream inStream) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        LineReader lr = new LineReader(inStream);
        while ((limit = lr.readLine()) >= 0) {
            char c = '\u0000';
            int keyLen = 0;
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            while (keyLen < limit) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
                ++keyLen;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            this.put(key, value);
        }
    }

    private List<String> store(OutputStream out, String comments) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (comments != null) {
            PropertySet.writeln(writer, "#" + comments);
        }
        PropertySet.writeln(writer, "#" + new Date().toString());
        HashMap c = null;
        try {
            c = (HashMap)this.clone();
        }
        catch (ConcurrentModificationException e) {
            this.log.error("\u975e\u540c\u671f\u5909\u66f4\u306b\u3088\u308a\u4fdd\u7ba1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", new Object[0]);
            return null;
        }
        ArrayList<String> keyList = new ArrayList<String>(c.keySet());
        Collections.sort(keyList, String.CASE_INSENSITIVE_ORDER);
        for (String key : keyList) {
            String val = (String)this.get(key);
            key = this.saveConvert(key, true);
            val = this.saveConvert(val, false);
            PropertySet.writeln(writer, String.valueOf(key) + "=" + val);
        }
        writer.flush();
        return keyList;
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    private String saveConvertComment(String theString) {
        String space = theString.replaceFirst("(\\s*).*", "$1");
        return String.valueOf(space) + this.saveConvert(theString.trim(), false);
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        break;
                    }
                    default: {
                        if (aChar < ' ' || aChar > '~') {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(PropertySet.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(PropertySet.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(PropertySet.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(PropertySet.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    class LineReader {
        byte[] inBuf = new byte[8192];
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        return len;
                    }
                }
                c = (char)(0xFF & this.inBuf[this.inOff++]);
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

