/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.FileNames;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationString
implements FileNames {
    private static final Logger log = Logger.getLogger(TranslationString.class);
    private static final char[] spaceChars = new char[]{' ', '\t', '\r', '\n'};
    private final String original;
    protected StringBuilder starts;
    protected StringBuilder ends;
    private String body;

    static {
        Arrays.sort(spaceChars);
    }

    public static String trim(String value) {
        return new TranslationString(value).trim();
    }

    public static String removeS(String en) {
        if (en.contains("(s)") && !en.contains(" (s)")) {
            return en.replace("(s)", "");
        }
        return en;
    }

    public static boolean isFormatedText(String en) {
        return en.contains("\n") && en.matches("(?s).*?\\n\\s.*");
    }

    public static boolean endsWithAbbreviations(String en) {
        return en.matches("(?s)(?i).*?[\\s\\p{Punct}](Inc|Ltd|etc|Reg|Exp|e\\.g)\\.");
    }

    public TranslationString(String value) {
        this.original = value;
        this.init();
    }

    private void init() {
        this.starts = new StringBuilder();
        this.ends = new StringBuilder();
        this.body = null;
    }

    public String toString() {
        return this.original;
    }

    public String trim() {
        Pattern pat;
        Matcher mat;
        if (this.body != null) {
            return this.body;
        }
        this.trimSpace(this.original);
        this.trimSurround("(", ")");
        this.trimSurround("[", "]");
        this.trimSurround("<!--", "-->");
        this.trimSurround("<", ">");
        this.trimSurround("\u300c", "\u300d");
        this.trimSurround("\"");
        this.trimSurround("'");
        this.trimSurround("!");
        if (this.body.startsWith("(") && !this.body.startsWith("( ") && !this.body.contains(")")) {
            this.trimStarts("(");
        } else if (this.body.endsWith(")") && !this.body.endsWith(" )") && !this.body.contains("(") && !this.body.endsWith(":)")) {
            this.trimEnds(")");
        }
        this.trimSpecific("&nbsp;");
        this.trimHyphen();
        if ((this.body.startsWith("I") || this.body.startsWith("C")) && (mat = (pat = Pattern.compile("(?s)^([A-Z]{3,4}\\d{4}[A-Z]{0,1}[\\s:]+)(.+)$")).matcher(this.body)).find()) {
            this.starts.append(mat.group(1));
            this.body = mat.group(2);
        }
        return this.body;
    }

    private void trimSpace(String str) {
        char c;
        char[] cs = str.toCharArray();
        int i = 0;
        while (i < cs.length) {
            c = cs[i];
            if (Arrays.binarySearch(spaceChars, c) < 0) break;
            this.starts.append(c);
            ++i;
        }
        i = cs.length - 1;
        while (i > 0) {
            c = cs[i];
            if (Arrays.binarySearch(spaceChars, c) < 0) break;
            this.ends.insert(0, c);
            --i;
        }
        if (this.starts.length() == this.original.length() || this.ends.length() == this.original.length()) {
            this.body = "";
            return;
        }
        this.body = this.original.substring(this.starts.length(), this.original.length() - this.ends.length());
    }

    private void trimSurround(String s) {
        this.trimSurround(s, s);
    }

    private void trimSurround(String s, String e) {
        if (!this.body.startsWith(s)) {
            return;
        }
        if (StringUtils.countMatches((String)this.body, (String)s) != (s.equals(e) ? 2 : 1)) {
            return;
        }
        if (this.body.endsWith(".") || this.body.endsWith("\u3002")) {
            e = String.valueOf(e) + this.body.substring(this.body.length() - 1);
        }
        if (!this.body.endsWith(e)) {
            return;
        }
        int sLen = s.length();
        int eLen = e.length();
        int bLen = this.body.length();
        this.starts.append(this.body.substring(0, sLen));
        this.ends.insert(0, this.body.substring(bLen - eLen).replace('.', '\u3002'));
        this.body = this.body.substring(sLen, bLen - eLen);
        this.trimSpace(this.body);
    }

    private void trimSpecific(String ... ss) {
        this.trimStarts(ss);
        this.trimEnds(ss);
    }

    private void trimStarts(String ... ss) {
        int len;
        do {
            len = this.body.length();
            String[] stringArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (this.body.startsWith(s)) {
                    this.starts.append(s);
                    this.body = this.body.substring(s.length());
                    this.trimSpace(this.body);
                }
                ++n2;
            }
        } while (this.body.length() != len && this.body.length() != 0);
    }

    private void trimEnds(String ... ss) {
        int len;
        do {
            len = this.body.length();
            String[] stringArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (this.body.endsWith(s)) {
                    this.ends.insert(0, s);
                    this.body = this.body.substring(0, this.body.length() - s.length());
                    this.trimSpace(this.body);
                }
                ++n2;
            }
        } while (this.body.length() != len && this.body.length() != 0);
    }

    protected void trimHyphen() {
        if (this.trimStartsWithSpace("-")) {
            this.trimEndsWithSpace("-");
        }
    }

    protected boolean trimStartsWithSpace(String s) {
        Pattern pat;
        Matcher mat;
        if (this.body.startsWith(s) && (mat = (pat = Pattern.compile("(?s)^(" + s + "+\\s+)(.+)$")).matcher(this.body)).find()) {
            this.starts.append(mat.group(1));
            this.body = mat.group(2);
            return true;
        }
        return false;
    }

    protected boolean trimEndsWithSpace(String s) {
        Pattern pat;
        Matcher mat;
        if (this.body.endsWith(s) && (mat = (pat = Pattern.compile("(?s)^(.+?)(\\s+" + s + "+)$")).matcher(this.body)).find()) {
            this.body = mat.group(1);
            this.ends.insert(0, mat.group(2));
            return true;
        }
        return false;
    }

    public String trimForce() {
        this.trim();
        this.trimSpecific(".", ":", "?", "!");
        String e = this.ends.toString();
        if (e.startsWith(".") && !e.startsWith("..")) {
            this.ends.replace(0, 1, "\u3002");
        }
        return this.body;
    }

    public String revert() {
        this.trim();
        return this.starts + this.body + this.ends;
    }

    public String revert(String jaBody) {
        this.trim();
        return this.starts + jaBody + this.ends;
    }

    public List<TranslationString> split() {
        this.init();
        this.trim();
        if (this.original.contains("\n")) {
            return null;
        }
        LinkedList<String> list = new LinkedList<String>();
        for (String s : this.splitParenthesis(this.body)) {
            list.addAll(this.splitPunct(s));
        }
        if (list.size() == 1) {
            return null;
        }
        LinkedList<TranslationString> tsList = new LinkedList<TranslationString>();
        int i = 0;
        while (i < list.size()) {
            if (i < list.size() - 1) {
                tsList.add(new SplitTranslationString((String)list.get(i)));
            } else {
                tsList.add(new TranslationString((String)list.get(i)));
            }
            ++i;
        }
        return tsList;
    }

    private List<String> splitParenthesis(String value) {
        LinkedList<String> list = new LinkedList<String>();
        if (!value.contains("(") && !value.contains("[")) {
            list.add(value);
            return list;
        }
        Pattern pat = Pattern.compile("(?s)^([\\(\\[][^\\{]+[\\)\\]]\\s)(.+)$");
        Matcher mat = pat.matcher(value);
        boolean isFound = false;
        if (mat.find()) {
            isFound = true;
        } else {
            pat = Pattern.compile("(?s)^(.+\\s)([\\(\\[][^\\{]+[\\)\\]](|[\\.\u3002:])\\s*)$");
            mat = pat.matcher(value);
            if (mat.find()) {
                if (this.invalidParenthesis(mat.group(2))) {
                    pat = Pattern.compile("(?s)^(.+?\\s)([\\(\\[][^\\{]+[\\)\\]](|[\\.\u3002:])\\s*)$");
                    mat = pat.matcher(value);
                    isFound = mat.find();
                } else {
                    isFound = true;
                }
            }
        }
        if (isFound) {
            String g1 = mat.group(1);
            String g2 = mat.group(2);
            if (this.invalidParenthesis(g1) || this.invalidParenthesis(g2)) {
                list.add(value);
            } else {
                list.addAll(this.splitParenthesis(g1));
                list.addAll(this.splitParenthesis(g2));
            }
        } else {
            list.add(value);
        }
        return list;
    }

    private boolean invalidParenthesis(String value) {
        return StringUtils.countMatches((String)value, (String)"(") != StringUtils.countMatches((String)value, (String)")") || StringUtils.countMatches((String)value, (String)"[") != StringUtils.countMatches((String)value, (String)"]");
    }

    private List<String> splitPunct(String value) {
        Pattern pat = Pattern.compile("\\s*([\u3002\uff1a\uff1f\uff01]+|[\\.:;\\?!]+(\\s|&nbsp;)+|\\s-\\s)\\s*");
        Matcher mat = pat.matcher(value);
        LinkedList<String> list = new LinkedList<String>();
        try {
            StringBuffer sb = new StringBuffer();
            while (mat.find()) {
                String sep = mat.group();
                int sPos = mat.start();
                int ePos = mat.end();
                if (sPos > 0 && ePos < value.length()) {
                    String ref;
                    String s = value.substring(0, sPos);
                    String e = value.substring(ePos);
                    if ((sep.contains(":") || sep.contains("-")) && e.contains("{") && e.matches("(?s).*?[^\\p{Punct}\\d].*") || (sep.contains(":") ? s.contains("(") && e.contains(")") : (sep.contains("-") ? s.endsWith("_") || s.matches("(?s).*\\d") && e.matches("(?s)\\d.*") : (sep.contains(".") ? sep.equals(" ... ") || sep.contains(" .") || TranslationString.endsWithAbbreviations(String.valueOf(s) + sep.charAt(0)) : (sep.startsWith(";") ? Mnemonics.containsHtmlReference(ref = String.valueOf(s.replaceFirst("(?s).*(&.+)", "$1")) + sep) : (sep.endsWith("\u3002") ? e.startsWith(")") : sep.contains("?") && e.startsWith("="))))))) continue;
                }
                mat.appendReplacement(sb, Matcher.quoteReplacement(sep));
                list.add(sb.toString());
                sb.delete(0, sb.length());
            }
            mat.appendTail(sb);
            if (sb.length() > 0) {
                list.add(sb.toString());
            }
        }
        catch (RuntimeException e) {
            log.error(e, "value[" + value + "] group[" + mat.group() + "]", new Object[0]);
            throw e;
        }
        return list;
    }

    private static class SplitTranslationString
    extends TranslationString {
        public SplitTranslationString(String value) {
            super(value);
        }

        protected void trimHyphen() {
            this.trimEndsWithSpace("-");
        }

        public String revert(String jaBody) {
            this.trim();
            if (jaBody.endsWith("\u3002") && this.ends.length() != 0) {
                if (this.ends.charAt(0) == ' ') {
                    this.ends.deleteCharAt(0);
                } else if (this.ends.toString().startsWith("&nbsp;")) {
                    this.ends.delete(0, 6);
                }
            } else if (this.ends.toString().startsWith("\u3002 ")) {
                this.ends.deleteCharAt(1);
            }
            return this.starts + jaBody + this.ends;
        }
    }
}

