/*
 * Decompiled with CFR 0.152.
 */
package tk.stepcounter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import tk.stepcounter.CountResult;
import tk.stepcounter.StepCounter;
import tk.stepcounter.StepCounterFactory;
import tk.stepcounter.Util;
import tk.stepcounter.format.FormatterFactory;
import tk.stepcounter.format.ResultFormatter;

public class Main {
    private File[] files;
    private ResultFormatter formatter;
    private PrintStream output = System.out;

    public void setFiles(File[] files) {
        this.files = files;
    }

    public void setFormatter(ResultFormatter formatter) {
        this.formatter = formatter;
    }

    public void setOutput(PrintStream output) {
        this.output = output;
    }

    public void executeCount() throws IOException {
        if (this.formatter == null) {
            this.formatter = FormatterFactory.getFormatter("");
        }
        ArrayList<CountResult> list = new ArrayList<CountResult>();
        int i = 0;
        while (i < this.files.length) {
            CountResult[] results = this.count(this.files[i]);
            int j = 0;
            while (j < results.length) {
                list.add(results[j]);
                ++j;
            }
            ++i;
        }
        CountResult[] results = list.toArray(new CountResult[list.size()]);
        this.output.println(this.formatter.format(results));
        this.output.flush();
        if (this.output != System.out) {
            this.output.close();
        }
    }

    private CountResult[] count(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            ArrayList<CountResult> list = new ArrayList<CountResult>();
            int i = 0;
            while (i < files.length) {
                CountResult[] results = this.count(files[i]);
                int j = 0;
                while (j < results.length) {
                    list.add(results[j]);
                    ++j;
                }
                ++i;
            }
            return list.toArray(new CountResult[list.size()]);
        }
        StepCounter counter = StepCounterFactory.getCounter(file.getName());
        if (counter != null) {
            CountResult result = counter.count(file);
            return new CountResult[]{result};
        }
        return new CountResult[]{new CountResult(file.getName(), null, 0L, 0L, 0L)};
    }

    public static void main(String[] args) throws IOException {
        if (args == null || args.length == 0) {
            System.exit(0);
        }
        String format = null;
        String output = null;
        ArrayList<File> fileList = new ArrayList<File>();
        int i = 0;
        while (i < args.length) {
            String[] dim;
            if (args[i].startsWith("-format=")) {
                dim = Util.split(args[i], "=");
                format = dim[1];
            } else if (args[i].startsWith("-output=")) {
                dim = Util.split(args[i], "=");
                output = dim[1];
            } else {
                fileList.add(new File(args[i]));
            }
            ++i;
        }
        Main main = new Main();
        main.setFiles(fileList.toArray(new File[fileList.size()]));
        main.setFormatter(FormatterFactory.getFormatter(format));
        if (output != null && !output.equals("")) {
            main.setOutput(new PrintStream(new FileOutputStream(new File(output))));
        }
        main.executeCount();
    }
}

