/*
 * Decompiled with CFR 0.152.
 */
package tk.stepcounter.format;

import tk.stepcounter.CountResult;
import tk.stepcounter.Util;
import tk.stepcounter.format.ResultFormatter;

public class DefaultFormatter
implements ResultFormatter {
    public String format(CountResult[] results) {
        long sumStep = 0L;
        long sumComment = 0L;
        long sumNone = 0L;
        StringBuffer sb = new StringBuffer();
        sb.append("\u30d5\u30a1\u30a4\u30eb                                \u7a2e\u985e  \u5b9f\u884c  \u7a7a\u884c  \uff7a\uff92\uff9d\uff84  \u5408\u8a08  ");
        sb.append("\n");
        sb.append("----------------------------------------------------------------------");
        sb.append("\n");
        int i = 0;
        while (i < results.length) {
            CountResult result = results[i];
            if (result.getFileType() == null) {
                sb.append(this.fillOrCut(result.getFileName(), 40));
                sb.append("\u672a\u5bfe\u5fdc");
                sb.append("\n");
            } else {
                String step = String.valueOf(result.getStep());
                String non = String.valueOf(result.getNon());
                String comment = String.valueOf(result.getComment());
                String sum = String.valueOf(result.getStep() + result.getNon() + result.getComment());
                sb.append(this.fillOrCut(result.getFileName(), 40));
                sb.append(this.fillOrCut(result.getFileType(), 6));
                sb.append(this.leftFillOrCut(step, 6));
                sb.append(this.leftFillOrCut(non, 6));
                sb.append(this.leftFillOrCut(comment, 6));
                sb.append(this.leftFillOrCut(sum, 6));
                sb.append("\n");
                sumStep += result.getStep();
                sumComment += result.getComment();
                sumNone += result.getNon();
            }
            ++i;
        }
        sb.append("----------------------------------------------------------------------");
        sb.append("\n");
        sb.append(this.fillOrCut("\u5408\u8a08", 40));
        sb.append(this.makeSpace(6));
        sb.append(this.leftFillOrCut(String.valueOf(sumStep), 6));
        sb.append(this.leftFillOrCut(String.valueOf(sumNone), 6));
        sb.append(this.leftFillOrCut(String.valueOf(sumComment), 6));
        sb.append(this.leftFillOrCut(String.valueOf(sumStep + sumNone + sumComment), 6));
        sb.append("\n");
        return sb.toString();
    }

    private String makeSpace(int width) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < width) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    private String fillOrCut(String str, int width) {
        int length = Util.getByteLength(str);
        if (length == width) {
            return str;
        }
        if (length < width) {
            return String.valueOf(str) + this.makeSpace(width - length);
        }
        return Util.substring(str, width);
    }

    private String leftFillOrCut(String str, int width) {
        int length = Util.getByteLength(str);
        if (length == width) {
            return str;
        }
        if (length < width) {
            return String.valueOf(this.makeSpace(width - length)) + str;
        }
        return Util.substring(str, width);
    }
}

