/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.Token;
import org.omegat.util.gui.TextUtil;

public class CalcMatchStatistics
extends LongProcessThread {
    private String[] header = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters")};
    private String[] rows = new String[]{OStrings.getString("CT_STATSMATCH_RowRepetitions"), OStrings.getString("CT_STATSMATCH_RowExactMatch"), OStrings.getString("CT_STATSMATCH_RowMatch95"), OStrings.getString("CT_STATSMATCH_RowMatch85"), OStrings.getString("CT_STATSMATCH_RowMatch75"), OStrings.getString("CT_STATSMATCH_RowMatch50"), OStrings.getString("CT_STATSMATCH_RowNoMatch")};
    private boolean[] align = new boolean[]{false, true, true, true, true};
    private StatisticsWindow callback;
    private Map<String, Token[]> tokensCache = new HashMap<String, Token[]>();
    private Set<String> alreadyProcessed = new HashSet<String>();

    public CalcMatchStatistics(StatisticsWindow statisticsWindow) {
        this.callback = statisticsWindow;
    }

    public void run() {
        Object object;
        StatCount[] statCountArray = new StatCount[7];
        for (int i = 0; i < statCountArray.length; ++i) {
            statCountArray[i] = new StatCount();
        }
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
        List<SourceTextEntry> list = Core.getProject().getAllEntries();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            int n2 = Statistics.getMaxSimilarityPercent((SourceTextEntry)object, levenshteinDistance, list, this.tokensCache, this.alreadyProcessed);
            int n3 = this.getRowByPercent(n2);
            ++statCountArray[n3].segments;
            statCountArray[n3].words += Statistics.numberOfWords(((SourceTextEntry)object).getSrcText());
            String string = StaticUtils.stripTags(((SourceTextEntry)object).getSrcText());
            statCountArray[n3].charsWithoutSpaces += Statistics.numberOfCharactersWithoutSpaces(string);
            statCountArray[n3].charsWithSpaces += string.length();
            if (this.isStopped) {
                return;
            }
            int n4 = i * 100 / list.size();
            if (n == n4) continue;
            this.callback.showProgress(n4);
            n = n4;
        }
        String[][] stringArray = this.calcTable(statCountArray);
        object = TextUtil.showTextTable(this.header, stringArray, this.align);
        this.callback.displayData((String)object);
        String string = Core.getProject().getProjectProperties().getProjectInternal() + "project_stats_match.txt";
        Statistics.writeStat(string, (String)object);
    }

    public int getRowByPercent(int n) {
        if (n == 102) {
            return 0;
        }
        if (n == 101) {
            return 1;
        }
        if (n >= 95) {
            return 2;
        }
        if (n >= 85) {
            return 3;
        }
        if (n >= 75) {
            return 4;
        }
        if (n >= 50) {
            return 5;
        }
        return 6;
    }

    public String[][] calcTable(StatCount[] statCountArray) {
        String[][] stringArray = new String[statCountArray.length][5];
        for (int i = 0; i < statCountArray.length; ++i) {
            stringArray[i][0] = this.rows[i];
            stringArray[i][1] = Integer.toString(statCountArray[i].segments);
            stringArray[i][2] = Integer.toString(statCountArray[i].words);
            stringArray[i][3] = Integer.toString(statCountArray[i].charsWithoutSpaces);
            stringArray[i][4] = Integer.toString(statCountArray[i].charsWithSpaces);
        }
        return stringArray;
    }
}

