/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.subtitles;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.util.OStrings;

public class SrtFilter
extends AbstractFilter {
    protected static final Pattern PATTERN_TIME_INTERVAL = Pattern.compile("([0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3})\\s+-->\\s+([0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3})");
    protected static final String EOL = "\r\n";

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.srt")};
    }

    public String getFileFormatName() {
        return OStrings.getString("SRTFILTER_FILTER_NAME");
    }

    public boolean isSourceEncodingVariable() {
        return true;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    protected void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException, TranslationException {
        String string;
        READ_STATE rEAD_STATE = READ_STATE.WAIT_TIME;
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            switch (rEAD_STATE) {
                case WAIT_TIME: {
                    if (PATTERN_TIME_INTERVAL.matcher(string).matches()) {
                        rEAD_STATE = READ_STATE.WAIT_TEXT;
                    }
                    bufferedWriter.write(string);
                    bufferedWriter.write(EOL);
                    break;
                }
                case WAIT_TEXT: {
                    if (string.trim().length() == 0) {
                        rEAD_STATE = READ_STATE.WAIT_TIME;
                    }
                    String string2 = this.processEntry(string);
                    bufferedWriter.write(string2);
                    bufferedWriter.write(EOL);
                }
            }
            ++n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum READ_STATE {
        WAIT_TIME,
        WAIT_TEXT;

    }
}

