/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3;

import java.util.ArrayList;
import java.util.List;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.Element;
import org.omegat.filters3.Tag;
import org.omegat.filters3.Text;
import org.omegat.util.PatternConsts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry {
    private boolean tagsDetected = false;
    private int firstGood;
    private int lastGood;
    private Text textInstance = null;
    private String translation = new String();
    Entry translatedEntry = null;
    private List<Element> elements = new ArrayList<Element>();

    public void clear() {
        this.tagsDetected = false;
        this.elements.clear();
        this.translation = new String();
        this.translatedEntry = null;
        this.textInstance = null;
    }

    private int getFirstGood() {
        this.detectAndEnumerateTags();
        return this.firstGood;
    }

    private int getLastGood() {
        this.detectAndEnumerateTags();
        return this.lastGood;
    }

    private Text getTextInstance() {
        this.detectAndEnumerateTags();
        return this.textInstance;
    }

    private void detectAndEnumerateTags() {
        if (!this.tagsDetected) {
            this.detectTags();
            this.tagsDetected = true;
            this.enumerateTags();
        }
    }

    private void detectTags() {
        Tag tag;
        Element element;
        int n;
        int n2;
        Tag tag2;
        Element element2;
        int n3;
        int n4;
        int n5 = -1;
        for (n4 = 0; n4 < this.size(); ++n4) {
            Element element3 = this.get(n4);
            if (!(element3 instanceof Text) || !((Text)element3).isMeaningful()) continue;
            n5 = n4;
            this.textInstance = (Text)element3;
            break;
        }
        if (n5 < 0) {
            this.firstGood = -1;
            this.lastGood = -2;
            this.textInstance = null;
            return;
        }
        n4 = n5;
        for (n3 = this.size() - 1; n3 >= 0; --n3) {
            element2 = this.get(n3);
            if (!(element2 instanceof Text) || !((Text)element2).isMeaningful()) continue;
            n4 = n3;
            break;
        }
        n3 = 0;
        this.firstGood = 0;
        while (this.firstGood < n5) {
            element2 = this.get(this.firstGood);
            if (element2 instanceof Tag && 1 == (tag2 = (Tag)element2).getType()) {
                n2 = 1;
                for (n = this.firstGood + 1; n < n4; ++n) {
                    element = this.get(n);
                    if (!(element instanceof Tag) || !(tag = (Tag)element).getTag().equals(tag2.getTag())) continue;
                    if (1 == tag.getType()) {
                        ++n2;
                        continue;
                    }
                    if (2 != tag.getType() || --n2 != 0) continue;
                    if (n <= n5) break;
                    n3 = 1;
                    break;
                }
                if (n3 != 0) break;
            }
            ++this.firstGood;
        }
        if (n3 == 0) {
            this.firstGood = n5;
        }
        n3 = 0;
        this.lastGood = this.size() - 1;
        while (this.lastGood > n4) {
            element2 = this.get(this.lastGood);
            if (element2 instanceof Tag && 2 == (tag2 = (Tag)element2).getType()) {
                n2 = 1;
                for (n = this.lastGood - 1; n > n5; --n) {
                    element = this.get(n);
                    if (!(element instanceof Tag) || !(tag = (Tag)element).getTag().equals(tag2.getTag())) continue;
                    if (2 == tag.getType()) {
                        ++n2;
                        continue;
                    }
                    if (1 != tag.getType() || --n2 != 0) continue;
                    if (n >= n4) break;
                    n3 = 1;
                    break;
                }
                if (n3 != 0) break;
            }
            --this.lastGood;
        }
        if (n3 == 0) {
            this.lastGood = n4;
        }
    }

    private void enumerateTags() {
        int n = 0;
        for (int i = this.getFirstGood(); i <= this.getLastGood(); ++i) {
            Element element = this.get(i);
            if (!(element instanceof Tag)) continue;
            Tag tag = (Tag)element;
            if (3 == tag.getType() || 1 == tag.getType()) {
                tag.setIndex(n);
                ++n;
                continue;
            }
            if (2 != tag.getType()) continue;
            tag.setIndex(-1);
            int n2 = 1;
            for (int j = i - 1; j >= this.getFirstGood(); --j) {
                Tag tag2;
                Element element2 = this.get(j);
                if (!(element2 instanceof Tag) || !(tag2 = (Tag)element2).getTag().equals(tag.getTag())) continue;
                if (2 == tag2.getType()) {
                    ++n2;
                    continue;
                }
                if (1 != tag2.getType() || --n2 != 0) continue;
                tag.setIndex(tag2.getIndex());
                break;
            }
            if (tag.getIndex() >= 0) continue;
            tag.setIndex(n);
            ++n;
        }
    }

    public String sourceToShortcut() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.getFirstGood(); i <= this.getLastGood(); ++i) {
            stringBuffer.append(this.get(i).toShortcut());
        }
        return stringBuffer.toString();
    }

    public String sourceToTMX() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append(this.get(i).toTMX());
        }
        return stringBuffer.toString();
    }

    public String sourceToOriginal() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append(this.get(i).toOriginal());
        }
        return stringBuffer.toString();
    }

    public void setTranslation(String string) throws TranslationException {
        if (string.length() > 0 && !this.sourceToShortcut().equals(string)) {
            this.checkAndRecoverTags(string);
            this.translation = string;
        }
    }

    private void checkAndRecoverTags(String string) throws TranslationException {
        this.translatedEntry = new Entry();
        List<ShortTag> list = this.listShortTags(string);
        int n = 0;
        block0: for (ShortTag shortTag : list) {
            if (n < shortTag.pos) {
                this.translatedEntry.add(this.getTextInstance().createInstance(string.substring(n, shortTag.pos)));
                n = shortTag.pos;
            }
            for (int i = this.getFirstGood(); i <= this.getLastGood(); ++i) {
                Tag tag;
                Element element = this.get(i);
                if (!(element instanceof Tag) || !(tag = (Tag)element).toShortcut().equals(shortTag.tag)) continue;
                this.translatedEntry.add(tag);
                n += shortTag.tag.length();
                continue block0;
            }
        }
        if (n < string.length()) {
            this.translatedEntry.add(this.getTextInstance().createInstance(string.substring(n)));
        }
    }

    private List<ShortTag> listShortTags(String string) {
        int n = 1;
        ArrayList<ShortTag> arrayList = new ArrayList<ShortTag>(string.length() / 4);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.setLength(0);
                stringBuffer.append(c);
                n = 2;
                continue;
            }
            if (c == '>') {
                stringBuffer.append(c);
                if (!PatternConsts.OMEGAT_TAG.matcher(stringBuffer).matches()) continue;
                arrayList.add(new ShortTag(stringBuffer.toString(), 1 + i - stringBuffer.length()));
                stringBuffer.setLength(0);
                n = 1;
                continue;
            }
            if (n != 2) continue;
            stringBuffer.append(c);
        }
        return arrayList;
    }

    public String translationToShortcut() {
        if (this.translation.length() == 0) {
            return this.sourceToShortcut();
        }
        return this.translation;
    }

    public String translationToTMX() {
        int n;
        if (this.translation.length() == 0) {
            return this.sourceToTMX();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.getFirstGood(); ++n) {
            stringBuffer.append(this.get(n).toTMX());
        }
        stringBuffer.append(this.translatedEntry.sourceToTMX());
        for (n = this.getLastGood() + 1; n < this.size(); ++n) {
            stringBuffer.append(this.get(n).toTMX());
        }
        return stringBuffer.toString();
    }

    public String translationToOriginal() {
        int n;
        if (this.translation.length() == 0) {
            return this.sourceToOriginal();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.getFirstGood(); ++n) {
            stringBuffer.append(this.get(n).toOriginal());
        }
        stringBuffer.append(this.translatedEntry.sourceToOriginal());
        for (n = this.getLastGood() + 1; n < this.size(); ++n) {
            stringBuffer.append(this.get(n).toOriginal());
        }
        return stringBuffer.toString();
    }

    public void add(Element element) {
        this.elements.add(element);
        this.tagsDetected = false;
    }

    public void remove(int n) {
        this.elements.remove(n);
        this.tagsDetected = false;
    }

    public Element get(int n) {
        return this.elements.get(n);
    }

    public int size() {
        return this.elements.size();
    }

    class ShortTag {
        String tag;
        int pos;

        ShortTag(String string, int n) {
            this.tag = string;
            this.pos = n;
        }
    }
}

