/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.help;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class HelpFrame
extends JFrame {
    private static HelpFrame singleton;
    private static final String ANCH_SETHOME = "#__sethome";
    private JEditorPane m_helpPane;
    private JButton m_closeButton;
    private JButton m_homeButton;
    private JButton m_backButton;
    private List<URL> m_historyList = new ArrayList<URL>();
    private URL m_filename;
    private URL m_home;

    private HelpFrame() {
        this.initWindowLayout();
        Container container = this.getContentPane();
        this.m_helpPane = new JEditorPane();
        this.m_helpPane.setEditable(false);
        this.m_helpPane.setContentType("text/html");
        JScrollPane jScrollPane = new JScrollPane(this.m_helpPane);
        container.add((Component)jScrollPane, "Center");
        this.m_homeButton = new JButton();
        this.m_homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.m_historyList.add(HelpFrame.this.m_filename);
                HelpFrame.this.displayHome();
                HelpFrame.this.m_backButton.setEnabled(!HelpFrame.this.m_historyList.isEmpty());
            }
        });
        this.m_backButton = new JButton();
        this.m_backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (HelpFrame.this.m_historyList.size() > 0) {
                    URL uRL = (URL)HelpFrame.this.m_historyList.remove(HelpFrame.this.m_historyList.size() - 1);
                    HelpFrame.this.displayURL(uRL);
                }
                HelpFrame.this.m_backButton.setEnabled(!HelpFrame.this.m_historyList.isEmpty());
            }
        });
        this.m_backButton.setEnabled(false);
        this.m_closeButton = new JButton();
        this.m_closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.dispose();
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(this.m_backButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.m_homeButton);
        box.add(Box.createHorizontalGlue());
        box.add(this.m_closeButton);
        container.add((Component)box, "North");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.m_helpPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpFrame.this.m_historyList.add(HelpFrame.this.m_filename);
                    HelpFrame.this.gotoLink(hyperlinkEvent.getDescription());
                    HelpFrame.this.m_backButton.setEnabled(!HelpFrame.this.m_historyList.isEmpty());
                }
            }
        });
        this.updateUIText();
        this.displayHome();
    }

    public static HelpFrame getInstance() {
        if (singleton == null) {
            singleton = new HelpFrame();
        }
        return singleton;
    }

    public static URL getHelpFileURL(String string, String string2) {
        String string3 = string != null ? string + File.separator + string2 : string2;
        File file = new File(StaticUtils.installDir() + File.separator + "docs" + File.separator + string3);
        try {
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string3 = string != null ? string + '/' + string2 : string2;
        URL uRL = HelpFrame.class.getResource("/docs/" + string3);
        return uRL;
    }

    public void displayHome() {
        if (this.m_home != null) {
            this.displayURL(this.m_home);
        } else {
            String string = HelpFrame.detectInitialLanguage();
            this.displayURL(HelpFrame.getHelpFileURL(string, "index.html"));
        }
    }

    private void gotoLink(String string) {
        if (string.startsWith("http://")) {
            String string2 = "<b>" + string + "</b>";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body><p>");
            stringBuffer.append(StaticUtils.format(OStrings.getString("HF_ERROR_EXTLINK_TITLE"), string2));
            stringBuffer.append("<p>");
            stringBuffer.append(StaticUtils.format(OStrings.getString("HF_ERROR_EXTLINK_MSG"), "<b>index.html</b>"));
            stringBuffer.append("</body></html>");
            this.m_helpPane.setText(stringBuffer.toString());
        } else {
            try {
                URL uRL = new URL(this.m_filename, string);
                if (string.endsWith(ANCH_SETHOME)) {
                    String string3 = uRL.toExternalForm();
                    string3 = string3.substring(0, string3.length() - ANCH_SETHOME.length());
                    this.m_home = uRL = new URL(string3);
                }
                this.displayURL(uRL);
            }
            catch (IOException iOException) {
                String string4 = this.errorHaiku() + "<p>&nbsp;<p>" + OStrings.getString("HF_CANT_FIND_HELP") + string;
                this.m_helpPane.setText(string4);
            }
        }
    }

    private void displayURL(URL uRL) {
        try {
            this.m_helpPane.setPage(uRL);
            this.m_filename = uRL;
        }
        catch (IOException iOException) {
            String string = this.errorHaiku() + "<p>&nbsp;<p>" + OStrings.getString("HF_CANT_FIND_HELP") + uRL;
            this.m_helpPane.setText(string);
        }
    }

    private String errorHaiku() {
        int n = new Random().nextInt(11) + 1;
        return OStrings.getString("HF_HAIKU_" + n);
    }

    private void updateUIText() {
        Mnemonics.setLocalizedText((AbstractButton)this.m_closeButton, (String)OStrings.getString("BUTTON_CLOSE"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_homeButton, (String)OStrings.getString("BUTTON_HOME"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_backButton, (String)OStrings.getString("BUTTON_BACK"));
        this.setTitle(OStrings.getString("HF_WINDOW_TITLE"));
    }

    private static String detectInitialLanguage() {
        String string = Locale.getDefault().getLanguage().toLowerCase();
        String string2 = Locale.getDefault().getCountry().toUpperCase();
        String string3 = string + "_" + string2;
        String string4 = HelpFrame.getDocVersion(string3);
        if (string4 != null && string4.equals(OStrings.VERSION)) {
            return string3;
        }
        string3 = string;
        string4 = HelpFrame.getDocVersion(string3);
        if (string4 != null && string4.equals(OStrings.VERSION)) {
            return string3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDocVersion(String string) {
        if (HelpFrame.getHelpFileURL(string, "index.html") == null) {
            return null;
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            URL uRL = HelpFrame.getHelpFileURL(string, "version.properties");
            inputStream = uRL.openStream();
            if (inputStream == null) {
                String string2 = null;
                return string2;
            }
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return properties.getProperty("version");
    }

    private void initWindowLayout() {
        try {
            String string = Preferences.getPreference("help_window_x");
            String string2 = Preferences.getPreference("help_window_y");
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            this.setLocation(n, n2);
            String string3 = Preferences.getPreference("help_window_width");
            String string4 = Preferences.getPreference("help_window_height");
            int n3 = Integer.parseInt(string3);
            int n4 = Integer.parseInt(string4);
            this.setSize(n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            this.setSize(600, 500);
        }
    }

    private void saveWindowLayout() {
        Preferences.setPreference("help_window_width", this.getWidth());
        Preferences.setPreference("help_window_height", this.getHeight());
        Preferences.setPreference("help_window_x", this.getX());
        Preferences.setPreference("help_window_y", this.getY());
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 201 || n == 202) {
            this.saveWindowLayout();
        }
        super.processWindowEvent(windowEvent);
    }
}

