/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.Preferences;

class EntryListPane
extends JTextPane {
    private StringBuffer m_stringBuf;
    private List<Integer> m_entryList;
    private List<Integer> m_offsetList;
    private MainWindow m_transFrame;

    public EntryListPane(MainWindow mainWindow) {
        this.m_transFrame = mainWindow;
        this.m_offsetList = new ArrayList<Integer>();
        this.m_entryList = new ArrayList<Integer>();
        this.m_stringBuf = new StringBuffer();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getClickCount() == 2) {
                    int n = EntryListPane.this.getCaretPosition();
                    for (int i = 0; i < EntryListPane.this.m_offsetList.size(); ++i) {
                        int n2 = (Integer)EntryListPane.this.m_offsetList.get(i);
                        if (n2 < n) continue;
                        final int n3 = (Integer)EntryListPane.this.m_entryList.get(i);
                        if (n3 < 0) break;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Core.getEditor().gotoEntry(n3);
                            }
                        });
                        break;
                    }
                }
            }
        });
        this.setEditable(false);
    }

    public void addEntry(int n, String string, String string2, String string3) {
        if (this.m_stringBuf.length() > 0) {
            this.m_stringBuf.append("---------\n");
        }
        if (string != null && !string.equals("")) {
            this.m_stringBuf.append(string + "\n");
        }
        if (string2 != null && !string2.equals("")) {
            this.m_stringBuf.append("-- " + string2 + "\n");
        }
        if (string3 != null && !string3.equals("")) {
            this.m_stringBuf.append("-- " + string3 + "\n");
        }
        this.m_entryList.add(n);
        this.m_offsetList.add(this.m_stringBuf.length());
    }

    public void addMessage(String string) {
        if (this.m_stringBuf.length() > 0) {
            this.m_stringBuf.append("---------\n");
        }
        this.m_stringBuf.append(string);
    }

    public void finalize() {
        String string = Preferences.getPreference("source_font");
        if (!string.equals("")) {
            int n;
            try {
                n = Integer.valueOf(Preferences.getPreference("source_font_size"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 12;
            }
            this.setFont(new Font(string, 0, n));
        }
        this.setText(this.m_stringBuf.toString());
    }

    public void reset() {
        this.m_entryList.clear();
        this.m_offsetList.clear();
        this.m_stringBuf.setLength(0);
        this.setText("");
    }

    public int getNrEntries() {
        return this.m_entryList.size();
    }
}

