/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;

public class LinebreakPreservingReader
extends Reader {
    private PushbackReader in;
    private StringBuffer linebreak = new StringBuffer(2);

    private LinebreakPreservingReader() {
    }

    public LinebreakPreservingReader(Reader reader) {
        this.in = new PushbackReader(reader);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public String getLinebreak() {
        return this.linebreak.toString();
    }

    public void mark(int n) throws IOException {
        this.in.mark(n);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(char[] cArray) throws IOException {
        return this.in.read(cArray);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.in.read(cArray, n, n2);
    }

    public String readLine() throws IOException {
        this.linebreak.setLength(0);
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n = this.in.read();
        if (n == -1) {
            return null;
        }
        while (n != -1 && !this.isLinebreakCharacter(n)) {
            stringBuffer.append((char)n);
            n = this.in.read();
        }
        if (this.isLinebreakCharacter(n)) {
            this.linebreak.append((char)n);
            if ((char)n == '\r') {
                n = this.in.read();
                if ((char)n == '\n') {
                    this.linebreak.append((char)n);
                } else {
                    this.in.unread(n);
                }
            }
        }
        return stringBuffer.toString();
    }

    public boolean ready() throws IOException {
        return this.in.ready();
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    private final boolean isLinebreakCharacter(int n) {
        return (char)n == '\n' || (char)n == '\r';
    }

    public void printLinebreak(PrintStream printStream) {
        printStream.print("Break: ");
        for (int i = 0; i < this.linebreak.length(); ++i) {
            char c = this.linebreak.charAt(i);
            if (c == '\r') {
                printStream.print("\\r");
                continue;
            }
            if (c == '\n') {
                printStream.print("\\n");
                continue;
            }
            printStream.print(c);
        }
        printStream.println();
    }
}

