/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class Log {
    private static Logger LOGGER;

    protected static void init(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        String string = properties.getProperty("handlers");
        if (string != null) {
            properties.remove("handlers");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, null);
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            Logger logger = LogManager.getLogManager().getLogger("");
            Object[] objectArray = logger.getHandlers();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Handler handler = objectArray[i];
                logger.removeHandler(handler);
            }
            for (Object object : objectArray = string.split(",")) {
                String string2 = ((String)object).trim();
                try {
                    Object object2;
                    Class<?> clazz = Log.class.getClassLoader().loadClass(string2);
                    Handler handler = (Handler)clazz.newInstance();
                    String string3 = properties.getProperty(string2 + ".formatter");
                    if (string3 != null) {
                        object2 = Log.class.getClassLoader().loadClass(string3.trim());
                        handler.setFormatter((Formatter)((Class)object2).newInstance());
                    }
                    if ((object2 = properties.getProperty(string2 + ".level")) != null) {
                        handler.setLevel(Level.parse((String)object2));
                    }
                    logger.addHandler(handler);
                }
                catch (Exception exception) {
                    System.err.println("Error in logger init: " + exception);
                    exception.printStackTrace();
                }
            }
        }
    }

    public static String getLogLocation() {
        return StaticUtils.getConfigDir() + "/logs";
    }

    public static void log(String string) {
        LOGGER.info(string);
    }

    public static void logRB(String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LogRecord logRecord = new LogRecord(Level.INFO, string);
            logRecord.setResourceBundle(OStrings.getResourceBundle());
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    public static void log(Throwable throwable) {
        LOGGER.log(Level.SEVERE, "", throwable);
    }

    public static void logWarningRB(String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LogRecord logRecord = new LogRecord(Level.WARNING, string);
            logRecord.setResourceBundle(OStrings.getResourceBundle());
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    public static void logInfoRB(String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LogRecord logRecord = new LogRecord(Level.INFO, string);
            logRecord.setResourceBundle(OStrings.getResourceBundle());
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    public static void logErrorRB(String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, string);
            logRecord.setResourceBundle(OStrings.getResourceBundle());
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    public static void logErrorRB(Throwable throwable, String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, string);
            logRecord.setResourceBundle(OStrings.getResourceBundle());
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(LOGGER.getName());
            logRecord.setThrown(throwable);
            LOGGER.log(logRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inputStream;
        LOGGER = Logger.global;
        boolean bl = false;
        File file = new File(StaticUtils.getConfigDir(), "logger.properties");
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
                try {
                    Log.init(inputStream);
                    bl = true;
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                inputStream = Log.class.getResourceAsStream("/org/omegat/logger.properties");
                try {
                    Log.init(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Can't open file for logging", iOException);
            }
        }
    }
}

