/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.StringEntry;
import org.omegat.core.data.TransMemory;
import org.omegat.util.OStrings;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMXWriter {
    public static void buildTMXFile(String string, boolean bl, boolean bl2, boolean bl3, ProjectProperties projectProperties, List<StringEntry> list, List<TransMemory> list2, boolean bl4, RuntimePreferences.PSEUDO_TRANSLATE_TYPE pSEUDO_TRANSLATE_TYPE) throws IOException {
        String string2 = projectProperties.getSourceLanguage().toString();
        String string3 = projectProperties.getTargetLanguage().toString();
        String string4 = projectProperties.isSentenceSegmentingEnabled() ? "sentence" : "paragraph";
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        String string5 = OStrings.VERSION;
        if (!OStrings.UPDATE.equals("0")) {
            string5 = string5 + "_" + OStrings.UPDATE;
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (bl3) {
            printWriter.println("<!DOCTYPE tmx SYSTEM \"tmx14.dtd\">");
        } else {
            printWriter.println("<!DOCTYPE tmx SYSTEM \"tmx11.dtd\">");
        }
        if (bl3) {
            printWriter.println("<tmx version=\"1.4\">");
        } else {
            printWriter.println("<tmx version=\"1.1\">");
        }
        printWriter.println("  <header");
        printWriter.println("    creationtool=\"OmegaT\"");
        printWriter.println("    creationtoolversion=\"" + string5 + "\"");
        printWriter.println("    segtype=\"" + string4 + "\"");
        printWriter.println("    o-tmf=\"OmegaT TMX\"");
        printWriter.println("    adminlang=\"EN-US\"");
        printWriter.println("    srclang=\"" + string2 + "\"");
        printWriter.println("    datatype=\"plaintext\"");
        printWriter.println("  >");
        printWriter.println("  </header>");
        printWriter.println("  <body>");
        String string6 = bl3 ? "xml:lang" : "lang";
        String string7 = null;
        String string8 = null;
        for (StringEntry object : list) {
            String string9 = string7 = bl ? StaticUtils.stripTags(object.getSrcText()) : object.getSrcText();
            if (!bl4) {
                String string10 = string8 = bl ? StaticUtils.stripTags(object.getTranslation()) : object.getTranslation();
                if (string8.length() == 0) {
                    continue;
                }
            } else {
                string8 = pSEUDO_TRANSLATE_TYPE.equals((Object)RuntimePreferences.PSEUDO_TRANSLATE_TYPE.EQUAL) ? string7 : "";
            }
            string7 = StaticUtils.makeValidXML(string7);
            string8 = StaticUtils.makeValidXML(string8);
            if (bl3) {
                string7 = TMXWriter.makeLevelTwo(string7);
                string8 = TMXWriter.makeLevelTwo(string8);
            }
            printWriter.println("    <tu>");
            printWriter.println("      <tuv " + string6 + "=\"" + string2 + "\">");
            printWriter.println("        <seg>" + string7 + "</seg>");
            printWriter.println("      </tuv>");
            printWriter.println("      <tuv " + string6 + "=\"" + string3 + "\">");
            printWriter.println("        <seg>" + string8 + "</seg>");
            printWriter.println("      </tuv>");
            printWriter.println("    </tu>");
        }
        if (bl2) {
            for (TransMemory transMemory : list2) {
                if (transMemory.target.length() == 0) continue;
                string7 = bl ? StaticUtils.stripTags(transMemory.source) : transMemory.source;
                String string11 = string8 = bl ? StaticUtils.stripTags(transMemory.target) : transMemory.target;
                if (bl3) {
                    string7 = TMXWriter.makeLevelTwo(string7);
                    string8 = TMXWriter.makeLevelTwo(string8);
                }
                if (string8.length() == 0) continue;
                string7 = StaticUtils.makeValidXML(string7);
                string8 = StaticUtils.makeValidXML(string8);
                printWriter.println("    <tu>");
                printWriter.println("      <tuv " + string6 + "=\"" + string2 + "\">");
                printWriter.println("        <seg>" + string7 + "</seg>");
                printWriter.println("      </tuv>");
                printWriter.println("      <tuv " + string6 + "=\"" + string3 + "\">");
                printWriter.println("        <seg>" + string8 + "</seg>");
                printWriter.println("      </tuv>");
                printWriter.println("    </tu>");
            }
        }
        printWriter.println("  </body>");
        printWriter.println("</tmx>");
        printWriter.close();
    }

    private static String makeLevelTwo(String string) {
        boolean bl;
        String string2;
        String string3;
        String string4;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        Matcher matcher = Pattern.compile("&lt;[\\S&&[^/\\d]]+(\\d+)/&gt;").matcher(string);
        int n = 0;
        while (matcher.find()) {
            string4 = matcher.group();
            string3 = matcher.group(1);
            stringBuffer.append(string.substring(n, matcher.start()));
            stringBuffer.append("<ph x='");
            stringBuffer.append(string3);
            stringBuffer.append("'>");
            stringBuffer.append(string4);
            stringBuffer.append("</ph>");
            n = matcher.end();
        }
        stringBuffer.append(string.substring(n, string.length()));
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        matcher = Pattern.compile("&lt;[\\S&&[^/\\d]]+(\\d+)&gt;").matcher(string);
        n = 0;
        while (matcher.find()) {
            string4 = matcher.group();
            string3 = matcher.group(1);
            string2 = "&lt;/" + string4.substring(4);
            bl = string.indexOf(string2) > -1;
            stringBuffer.append(string.substring(n, matcher.start()));
            if (bl) {
                stringBuffer.append("<bpt i='");
                stringBuffer.append(string3);
                stringBuffer.append("'");
            } else {
                stringBuffer.append("<it pos='begin'");
            }
            stringBuffer.append(" x='");
            stringBuffer.append(string3);
            stringBuffer.append("'>");
            stringBuffer.append(string4);
            stringBuffer.append(bl ? "</bpt>" : "</it>");
            n = matcher.end();
        }
        stringBuffer.append(string.substring(n, string.length()));
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        matcher = Pattern.compile("&lt;/[\\S&&[^\\d]]+(\\d+)&gt;").matcher(string);
        n = 0;
        while (matcher.find()) {
            string4 = matcher.group();
            string3 = matcher.group(1);
            string2 = "&lt;" + string4.substring(5);
            bl = string.indexOf(string2) > -1;
            stringBuffer.append(string.substring(n, matcher.start()));
            stringBuffer.append(bl ? "<ept i='" : "<it pos='end' x='");
            stringBuffer.append(string3);
            stringBuffer.append("'>");
            stringBuffer.append(string4);
            stringBuffer.append(bl ? "</ept>" : "</it>");
            n = matcher.end();
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }
}

