/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.build.stepcounter.record;

/**
 * blancoCsvファイル定義書から作成されたレコードクラス\nファイル定義[StepCounter]のレコードクラス\n
 */
public class StepCounterCsvRecord {
    /**
     * 項目の説明: 名前\n
     *
     * フィールド: [name]。
     */
    private String fName;

    /**
     * 項目の説明: タイプ\n
     *
     * フィールド: [type]。
     */
    private String fType;

    /**
     * 項目の説明: 実行\n
     *
     * フィールド: [loc]。
     */
    private Integer fLoc;

    /**
     * 項目の説明: 空行\n
     *
     * フィールド: [blanc]。
     */
    private Integer fBlanc;

    /**
     * 項目の説明: コメント\n
     *
     * フィールド: [comment]。
     */
    private Integer fComment;

    /**
     * 項目の説明: 合計\n
     *
     * フィールド: [total]。
     */
    private Integer fTotal;

    /**
     * フィールド [name] の値を設定します。
     *
     * フィールドの説明: [項目の説明: 名前
     * ]。
     *
     * @param argName フィールド[name]に設定する値。
     */
    public void setName(final String argName) {
        fName = argName;
    }

    /**
     * フィールド [name] の値を取得します。
     *
     * フィールドの説明: [項目の説明: 名前
     * ]。
     *
     * @return フィールド[name]から取得した値。
     */
    public String getName() {
        return fName;
    }

    /**
     * フィールド [type] の値を設定します。
     *
     * フィールドの説明: [項目の説明: タイプ
     * ]。
     *
     * @param argType フィールド[type]に設定する値。
     */
    public void setType(final String argType) {
        fType = argType;
    }

    /**
     * フィールド [type] の値を取得します。
     *
     * フィールドの説明: [項目の説明: タイプ
     * ]。
     *
     * @return フィールド[type]から取得した値。
     */
    public String getType() {
        return fType;
    }

    /**
     * フィールド [loc] の値を設定します。
     *
     * フィールドの説明: [項目の説明: 実行
     * ]。
     *
     * @param argLoc フィールド[loc]に設定する値。
     */
    public void setLoc(final Integer argLoc) {
        fLoc = argLoc;
    }

    /**
     * フィールド [loc] の値を取得します。
     *
     * フィールドの説明: [項目の説明: 実行
     * ]。
     *
     * @return フィールド[loc]から取得した値。
     */
    public Integer getLoc() {
        return fLoc;
    }

    /**
     * フィールド [blanc] の値を設定します。
     *
     * フィールドの説明: [項目の説明: 空行
     * ]。
     *
     * @param argBlanc フィールド[blanc]に設定する値。
     */
    public void setBlanc(final Integer argBlanc) {
        fBlanc = argBlanc;
    }

    /**
     * フィールド [blanc] の値を取得します。
     *
     * フィールドの説明: [項目の説明: 空行
     * ]。
     *
     * @return フィールド[blanc]から取得した値。
     */
    public Integer getBlanc() {
        return fBlanc;
    }

    /**
     * フィールド [comment] の値を設定します。
     *
     * フィールドの説明: [項目の説明: コメント
     * ]。
     *
     * @param argComment フィールド[comment]に設定する値。
     */
    public void setComment(final Integer argComment) {
        fComment = argComment;
    }

    /**
     * フィールド [comment] の値を取得します。
     *
     * フィールドの説明: [項目の説明: コメント
     * ]。
     *
     * @return フィールド[comment]から取得した値。
     */
    public Integer getComment() {
        return fComment;
    }

    /**
     * フィールド [total] の値を設定します。
     *
     * フィールドの説明: [項目の説明: 合計
     * ]。
     *
     * @param argTotal フィールド[total]に設定する値。
     */
    public void setTotal(final Integer argTotal) {
        fTotal = argTotal;
    }

    /**
     * フィールド [total] の値を取得します。
     *
     * フィールドの説明: [項目の説明: 合計
     * ]。
     *
     * @return フィールド[total]から取得した値。
     */
    public Integer getTotal() {
        return fTotal;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.cat.build.stepcounter.record.StepCounterCsvRecord[");
        buf.append("name=" + fName);
        buf.append(",type=" + fType);
        buf.append(",loc=" + fLoc);
        buf.append(",blanc=" + fBlanc);
        buf.append(",comment=" + fComment);
        buf.append(",total=" + fTotal);
        buf.append("]");
        return buf.toString();
    }
}
