/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.build.stepcounter.task.valueobject;

/**
 * 処理クラス [StepCounterCsvProcess]の入力バリューオブジェクトクラスです。
 */
public class StepCounterCsvProcessInput {
    /**
     * verboseモードで動作させるかどうか。
     *
     * フィールド: [verbose]。
     * デフォルト: [false]。
     */
    private boolean fVerbose = false;

    /**
     * StepCounterが出力したCSVファイルが格納されている\nディレクトリを指定します。
     *
     * フィールド: [targetDir]。
     */
    private String fTargetDir;

    /**
     * フィールド [verbose] の値を設定します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     *
     * @param argVerbose フィールド[verbose]に設定する値。
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * フィールド [verbose] の値を取得します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[verbose]から取得した値。
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * フィールド [targetDir] の値を設定します。
     *
     * フィールドの説明: [StepCounterが出力したCSVファイルが格納されている\nディレクトリを指定します。]。
     *
     * @param argTargetDir フィールド[targetDir]に設定する値。
     */
    public void setTargetDir(final String argTargetDir) {
        fTargetDir = argTargetDir;
    }

    /**
     * フィールド [targetDir] の値を取得します。
     *
     * フィールドの説明: [StepCounterが出力したCSVファイルが格納されている\nディレクトリを指定します。]。
     *
     * @return フィールド[targetDir]から取得した値。
     */
    public String getTargetDir() {
        return fTargetDir;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.cat.build.stepcounter.task.valueobject.StepCounterCsvProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",targetDir=" + fTargetDir);
        buf.append("]");
        return buf.toString();
    }
}
