/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.core;

import junit.framework.TestCase;

public class BentenGlossaryDriverManagerTest extends TestCase {

	private static class TestGlossaryDriver1 implements BentenGlossaryDriver {
		public String getName() {
			return "test1";
		}
		public BentenGlossaryEngine getEngineInstance() {
			return null;
		}
	}

	private static class TestGlossaryDriver2 implements BentenGlossaryDriver {
		public String getName() {
			return "test2";
		}
		public BentenGlossaryEngine getEngineInstance() {
			return null;
		}
	}

	public void testRegisterDriver() {
		try {
			BentenGlossaryDriverManager.registerDriver(null);
			fail();
		} catch (final IllegalArgumentException e) {
			assertTrue(true);
		}
		try {
			BentenGlossaryDriverManager.deregisterDriver(null);
			fail();
		} catch (final IllegalArgumentException e) {
			assertTrue(true);
		}

		final int base = BentenGlossaryDriverManager.getDrivers().length;

		BentenGlossaryDriverManager.registerDriver(new TestGlossaryDriver2());
		assertEquals(base + 1, BentenGlossaryDriverManager.getDrivers().length);

		BentenGlossaryDriverManager.registerDriver(new TestGlossaryDriver2());
		assertEquals(base + 1, BentenGlossaryDriverManager.getDrivers().length);

		BentenGlossaryDriverManager.registerDriver(new TestGlossaryDriver1());
		assertNotNull(BentenGlossaryDriverManager.getDriver("test1"));
		assertEquals(base + 2, BentenGlossaryDriverManager.getDrivers().length);

		BentenGlossaryDriverManager.deregisterDriver(new TestGlossaryDriver1());
		assertEquals(base + 1, BentenGlossaryDriverManager.getDrivers().length);

		BentenGlossaryDriverManager.deregisterDriver(new TestGlossaryDriver1());
		assertEquals(base + 1, BentenGlossaryDriverManager.getDrivers().length);

		BentenGlossaryDriverManager.deregisterDriver(new TestGlossaryDriver2());
		assertEquals(base + 0, BentenGlossaryDriverManager.getDrivers().length);

		BentenGlossaryDriverManager.deregisterDriver(new TestGlossaryDriver2());
		assertEquals(base + 0, BentenGlossaryDriverManager.getDrivers().length);
	}
}
