/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.core;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * Benten 用語集エンジンをあらわすインタフェース。
 *
 * <UL>
 * <LI>用語集の処理そのものです。
 * <LI>このインタフェースを実装して、用語集エンジンを実装します。
 * <LI>用語集エンジンに対応する用語集ドライバーを提供することにより、用語集エンジンが Benten で有効になります。
 * </UL>
 * 
 * @author IGA Tosiki
 */
public interface BentenGlossaryEngine {
	/**
	 * 翻訳言語を設定。
	 * 
	 * @param source 翻訳元の言語。例: en-US。
	 * @param target 翻訳先の言語。例: ja-JP。
	 */
	void setLang(String source, String target);

	/**
	 * 基軸言語を設定。
	 * 
	 * @param pivotLang 基軸言語。例: en-US。
	 */
	void setPivotLang(String pivotLang);

	/**
	 * TSV 形式用語集のロード。
	 *
	 * <UL>
	 * <LI>タブ区切り形式ファイルの用語集をロードします。
	 * <LI>このメソッドを呼ぶと、追加的に用語集が構築されます。
	 * </UL>
	 * 
	 * @param dirTsv TSV 形式のファイルが格納されたディレクトリー。
	 * @throws IOException 入出力例外が発生した場合。
	 */
	void loadTsv(File dirTsv) throws IOException;

	/**
	 * 用語集のアンロード。
	 *
	 * <UL>
	 * <LI>このエンジンが保持している用語集を破棄します。
	 * </UL>
	 */
	void unload();

	/**
	 * 用語集を検索して用語エントリーのリストを取得。
	 *
	 * <UL>
	 * <LI>用語集を検索して用語エントリーのリストを取得します。
	 * </UL>
	 * 
	 * @param search 検索したい用語。
	 * @return 用語エントリーのリスト。
	 */
	List<BentenGlossarySearchResult> search(String search);
}
