/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.engine;

import benten.cat.glossary.core.BentenGlossaryDriver;
import benten.cat.glossary.core.BentenGlossaryEngine;
import benten.core.AbstractBentenPlugin;

/**
 * Benten 用語集エンジンのための抽象プラグイン。
 *
 * <UL>
 * <LI>Benten 用語集エンジン提供者は、Eclipse 上でエンジンを有効にするために、このクラスを継承したクラスを提供する必要があります。
 * <LI>この抽象クラスを継承し、かつ拡張ポイントを提供しているものが、用語集エンジン・プラグインとして動作します。
 * </UL>
 * 
 * @author YAMAMOTO Koji
 */
public abstract class AbstractBentenGlossaryEnginePlugin extends AbstractBentenPlugin {
	/**
	 * このプラグインが利用する用語集エンジンのインスタンス。
	 */
	protected BentenGlossaryEngine fEngine = null;

	/**
	 * このプラグインの共用インスタンスを取得。
	 *
	 * <UL>
	 * <LI>getDefault メソッドの代わりになるものです。
	 * <LI>一般的な Eclipse プラグインの流儀とは異なり、非 static メソッドとなっています。
	 * <LI>このメソッドは、クラスが保持する static フィールドの値を暴露します。
	 * </UL>
	 * 
	 * @return このプラグインの共用インスタンス。
	 */
	public abstract AbstractBentenGlossaryEnginePlugin getPluginDefault();

	/**
	 * 用語集エンジンのドライバーを取得します。
	 * 
	 * @return 用語集エンジン・ドライバーのインスタンス。
	 */
	public abstract BentenGlossaryDriver getDriver();

	/**
	 * プラグインが保持している用語集エンジンのインスタンスを取得します。
	 * 
	 * @return プラグインが保持している用語集エンジンのインスタンス。
	 */
	public abstract BentenGlossaryEngine getEngine();

	/**
	 * 用語集データをロードします。
	 *
	 * 一般的な処理内容は以下のようになります。
	 *
	 * <UL>
	 * <LI>最初にエンジンが保持している用語集データをアンロードします。
	 * <LI>拡張ポイント登録一覧から、この用語集エンジンが処理可能な拡張ポイントを取得します。
	 * <LI>得られた拡張ポイントから処理可能な拡張のリストを取得します。
	 * <LI>拡張のリストの中で、この用語集エンジンが期待する名称の拡張を取得します。
	 * <LI>得られた拡張から、用語集データを読み込みます。
	 * </UL>
	 */
	public abstract void load();
}
