/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.ui.views;

import junit.framework.TestCase;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.PartInitException;

import benten.cat.glossary.core.BentenGlossarySearchResult;
import benten.cat.glossary.ui.views.GlossaryView.GlossaryNoteSortListener;
import benten.cat.glossary.ui.views.GlossaryView.GlossarySourceSortListener;
import benten.cat.glossary.ui.views.GlossaryView.GlossaryTargetSortListener;
import benten.ui.UiPlugin;
import benten.ui.views.TableColumnSortAdapter;
import benten.ui.views.TableColumnSortAdapter.TableColumnSorter;

public class GlossaryViewTest extends TestCase {

	final GlossaryView view = new GlossaryView() {
		@Override
		protected void createContextMenu() {
		}
		@Override
		protected void contributeToActionBars() {
		}
	};

	@SuppressWarnings("unchecked")
	private TableColumnSortAdapter<BentenGlossarySearchResult> getListener(final int columnIndex) {
		final Table table = view.getTableViewer().getTable();
		final Listener listener = table.getColumn(columnIndex).getListeners(SWT.Selection)[0];
		return (TableColumnSortAdapter<BentenGlossarySearchResult>) ((TypedListener) listener).getEventListener();
	}

	private BentenGlossarySearchResult createModel(final String s, final String t, final String n) {
		final BentenGlossarySearchResult model = new BentenGlossarySearchResult();
		model.setSource(s);
		model.setTarget(t);
		model.setNote(n);
		return model;
	}

	public void testCreateTableViewer() throws PartInitException {
		view.createPartControl(UiPlugin.getShell());
		final Table table = view.getTableViewer().getTable();

		assertEquals(3, table.getColumnCount());

		assertTrue(getListener(0) instanceof GlossarySourceSortListener);
		assertTrue(getListener(1) instanceof GlossaryTargetSortListener);
		assertTrue(getListener(2) instanceof GlossaryNoteSortListener);

		assertEquals(0, getListener(0).getColumnIndex());
		assertEquals(1, getListener(1).getColumnIndex());
		assertEquals(2, getListener(2).getColumnIndex());

		final BentenGlossarySearchResult model1 = createModel("s1", "t2", "n1");
		final BentenGlossarySearchResult model2 = createModel("s2", "t1", "n2");
		TableColumnSorter<BentenGlossarySearchResult> sorter = null;

		sorter = getListener(0).createTableColumnSorter();
		assertTrue(sorter.compare(model1, model1) == 0);
		assertTrue(sorter.compare(model1, model2) < 0);
		assertTrue(sorter.compare(model2, model1) > 0);

		sorter = getListener(1).createTableColumnSorter();
		assertTrue(sorter.compare(model1, model1) == 0);
		assertTrue(sorter.compare(model1, model2) > 0);
		assertTrue(sorter.compare(model2, model1) < 0);

		sorter = getListener(2).createTableColumnSorter();
		assertTrue(sorter.compare(model1, model1) == 0);
		assertTrue(sorter.compare(model1, model2) < 0);
		assertTrue(sorter.compare(model2, model1) > 0);
	}
}
