/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.handler;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import junit.framework.TestCase;
import benten.cat.glossary.core.BentenGlossaryEngine;
import benten.cat.glossary.core.BentenGlossarySearchResult;
import benten.cat.stat.model.GlossaryHitRateModel;

public class ShowGlossaryHitRateHandlerTest extends TestCase {

	private final ShowGlossaryHitRateHandler handler = new ShowGlossaryHitRateHandler() {
		@Override
		protected BentenGlossaryEngine getGlossaryEngine() {
			return new BentenGlossaryEngine() {
				public void loadTsv(final File dirTsv) throws IOException {
				}

				public List<BentenGlossarySearchResult> search(final String search) {
					final LinkedList<BentenGlossarySearchResult> list = new LinkedList<BentenGlossarySearchResult>();
					if (hitWhenFirstAccess) {
						list.add(null);
						hitWhenFirstAccess = false;
					}
					return list;
				}

				public void unload() {
				}

				public void setLang(String source, String target) {
				}

				public void setPivotLang(String pivotLang) {
				}
			};
		}
	};

	private boolean hitWhenFirstAccess;

	public void testSetModel() {
		final GlossaryHitRateModel model = new GlossaryHitRateModel();
		try {
			handler.setModel(null, null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}

		hitWhenFirstAccess = false;
		handler.setModel(null, model);
		assertEquals(0, model.getHit75());
		assertEquals(0, model.getHit50());
		assertEquals(0, model.getHit25());
		assertEquals(1, model.getHitUnder25());

		hitWhenFirstAccess = false;
		handler.setModel("test", model);
		assertEquals(0, model.getHit75());
		assertEquals(0, model.getHit50());
		assertEquals(0, model.getHit25());
		assertEquals(2, model.getHitUnder25());

		hitWhenFirstAccess = true;
		handler.setModel("test", model);
		assertEquals(1, model.getHit75());
		assertEquals(0, model.getHit50());
		assertEquals(0, model.getHit25());
		assertEquals(2, model.getHitUnder25());

		hitWhenFirstAccess = true;
		handler.setModel("test test", model);
		assertEquals(1, model.getHit75());
		assertEquals(1, model.getHit50());
		assertEquals(0, model.getHit25());
		assertEquals(2, model.getHitUnder25());

		hitWhenFirstAccess = true;
		handler.setModel("test test test", model);
		assertEquals(1, model.getHit75());
		assertEquals(1, model.getHit50());
		assertEquals(1, model.getHit25());
		assertEquals(2, model.getHitUnder25());

		hitWhenFirstAccess = true;
		handler.setModel("test test test test", model);
		assertEquals(1, model.getHit75());
		assertEquals(1, model.getHit50());
		assertEquals(2, model.getHit25());
		assertEquals(2, model.getHitUnder25());

		hitWhenFirstAccess = true;
		handler.setModel("test test test test test", model);
		assertEquals(1, model.getHit75());
		assertEquals(1, model.getHit50());
		assertEquals(2, model.getHit25());
		assertEquals(3, model.getHitUnder25());
	}
}
