/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.stat.views.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 用語対訳集ヒット率ビューのためのメッセージ。
 *
 * リソースバンドル定義: [TmHitRateViewMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class TmHitRateViewMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * TmHitRateViewMessagesクラスのコンストラクタ。
     *
     * 基底名[TmHitRateViewMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public TmHitRateViewMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/TmHitRateViewMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TmHitRateViewMessagesクラスのコンストラクタ。
     *
     * 基底名[TmHitRateViewMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public TmHitRateViewMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/TmHitRateViewMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TmHitRateViewMessagesクラスのコンストラクタ。
     *
     * 基底名[TmHitRateViewMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public TmHitRateViewMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/TmHitRateViewMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[TmHitRateViewMessages], key[resource]
     *
     * [Resource] (en)<br>
     * [リソース] (ja)<br>
     *
     * @return key[resource]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getResource() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Resource";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("resource");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TmHitRateViewMessages], key[exact_match]
     *
     * [100%] (en)<br>
     * [100%] (ja)<br>
     *
     * @return key[exact_match]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getExactMatch() {
        // 初期値として定義書の値を利用します。
        String strFormat = "100%";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("exact_match");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TmHitRateViewMessages], key[more_than_95]
     *
     * [&gt;= 95%] (en)<br>
     * [&gt;= 95%] (ja)<br>
     *
     * @return key[more_than_95]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMoreThan95() {
        // 初期値として定義書の値を利用します。
        String strFormat = ">= 95%";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("more_than_95");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TmHitRateViewMessages], key[more_than_85]
     *
     * [&gt;= 85%] (en)<br>
     * [&gt;= 85%] (ja)<br>
     *
     * @return key[more_than_85]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMoreThan85() {
        // 初期値として定義書の値を利用します。
        String strFormat = ">= 85%";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("more_than_85");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TmHitRateViewMessages], key[more_than_75]
     *
     * [&gt;= 75%] (en)<br>
     * [&gt;= 75%] (ja)<br>
     *
     * @return key[more_than_75]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMoreThan75() {
        // 初期値として定義書の値を利用します。
        String strFormat = ">= 75%";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("more_than_75");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TmHitRateViewMessages], key[less_than_75]
     *
     * [&lt; 75%] (en)<br>
     * [&lt; 75%] (ja)<br>
     *
     * @return key[less_than_75]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLessThan75() {
        // 初期値として定義書の値を利用します。
        String strFormat = "< 75%";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("less_than_75");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
