/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.stat.views.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * ワード数ビューのためのメッセージ。
 *
 * リソースバンドル定義: [WordCountViewMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class WordCountViewMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * WordCountViewMessagesクラスのコンストラクタ。
     *
     * 基底名[WordCountViewMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public WordCountViewMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/WordCountViewMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * WordCountViewMessagesクラスのコンストラクタ。
     *
     * 基底名[WordCountViewMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public WordCountViewMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/WordCountViewMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * WordCountViewMessagesクラスのコンストラクタ。
     *
     * 基底名[WordCountViewMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public WordCountViewMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/stat/views/messages/WordCountViewMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[WordCountViewMessages], key[Resource]
     *
     * [Resource] (en)<br>
     * [リソース] (ja)<br>
     *
     * @return key[Resource]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getResource() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Resource";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Resource");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[WordCountViewMessages], key[WordCount]
     *
     * [Word Count] (en)<br>
     * [ワード数] (ja)<br>
     *
     * @return key[WordCount]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWordCount() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Word Count";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WordCount");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
