/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.views;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

import benten.cat.stat.CatStatPlugin;
import benten.cat.stat.model.AbstractStatModel;
import benten.core.io.ResourceFile;
import benten.ui.views.AutoColumnWidthTableViewer;

/**
 * 翻訳統計取得ビューの基底クラス。
 *
 * <UL>
 * <LI>すべての翻訳統計取得ビューの基底クラスです。
 * <LI>共通のリスナー設定、メニューの設定を提供します。
 * </UL>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳統計取得機能: 翻訳メモリー・ヒット率ビュー」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public abstract class AbstractStatView extends ViewPart {

	/**
	 * 自動カラム幅テーブル・ビューアー
	 */
	private AutoColumnWidthTableViewer viewer;

	@Override
	public void createPartControl(final Composite parent) {
		viewer = new AutoColumnWidthTableViewer(parent);

		createTableViewer(viewer);

		viewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(final DoubleClickEvent event) {
				final IStructuredSelection selection = (IStructuredSelection) event.getSelection();
				final AbstractStatModel model = (AbstractStatModel) selection.getFirstElement();
				final ResourceFile file = (ResourceFile) model.getFile();
				final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
				try {
					IDE.openEditor(window.getActivePage(), (IFile) file.getResource());
				} catch (final PartInitException e) {
					CatStatPlugin.getDefault().log(e);
				}
			}
		});
	}

	/**
	 * テーブル･ビューアーを作成するテンプレート・メソッド。
	 * @param viewer ビューアー
	 */
	abstract protected void createTableViewer(final AutoColumnWidthTableViewer viewer);

	@Override
	public void setFocus() {
		viewer.getTable().setFocus();
	}

	/**
	 * 入力モデルの設定。
	 * @param models モデルのリスト
	 */
	public void setInput(final List<?> models) {
		viewer.setInput(models);

		// 第一カラムを再セットすることで、リサイズ時に横スクロールバーが表示されるのを抑止
		// → TableColumnLayout のバグ扱いとし、対応しない 2009.07.10
		//Display.getCurrent().asyncExec(new Runnable() {
		//	public void run() {
		//		final TableColumn column = viewer.getTable().getColumn(0);
		//		column.setWidth(column.getWidth());
		//	}
		//});
	}
}
