/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.core;

/**
 * Benten TM (翻訳メモリー) ドライバーをあらわすインタフェース。
 * 
 * <UL>
 * <LI>Benten に TM エンジンを追加する場合には、このインタフェースを実装した TM ドライバーを提供する必要があります。
 * <LI>ドライバー実装で自分自身を BentenTmDriverManager に登録することにより、ドライバーが Benten で有効になります。
 * </UL>
 * 
 * @author IGA Tosiki
 */
public interface BentenTmDriver {
	/**
	 * TM ドライバーの名前を取得。
	 * 
	 * @return TM エンジン名。
	 */
	String getName();

	/**
	 * TM エンジンの取得。
	 * 
	 * <UL>
	 * <LI>ドライバーに対応するエンジンのインスタンスを新規に作成し、これを取得します。
	 * </UL>
	 * 
	 * @return TM エンジンのインスタンス。
	 */
	BentenTmEngine getEngineInstance();
}
