/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.engine;

import benten.cat.tm.core.BentenTmDriver;
import benten.cat.tm.core.BentenTmEngine;
import benten.core.AbstractBentenPlugin;

/**
 * Benten TM (翻訳メモリー) のための抽象プラグイン。
 * 
 * <UL>
 * <LI>Benten TM エンジン提供者は、Eclipse 上でエンジンを有効にするために、このクラスを継承したクラスを提供する必要があります。
 * <LI>この抽象クラスを継承し、かつ拡張ポイントを提供しているものが、TM エンジン・プラグインとして動作します。
 * </UL>
 * 
 * @author YAMAMOTO Koji
 */
public abstract class AbstractBentenTmEnginePlugin extends AbstractBentenPlugin {
	/**
	 * このプラグインが利用する TM エンジンのインスタンス。
	 */
	protected BentenTmEngine fEngine = null;

	/**
	 * このプラグインの共用インスタンスを取得。
	 * 
	 * <UL>
	 * <LI>getDefault メソッドの代わりになるものです。
	 * <LI>一般的な Eclipse プラグインの流儀とは異なり、非 static メソッドとなっています。
	 * <LI>このメソッドは、クラスが保持する static フィールドの値を暴露します。
	 * </UL>
	 * 
	 * @return このプラグインの共用インスタンス。
	 */
	public abstract AbstractBentenTmEnginePlugin getPluginDefault();

	/**
	 * TM エンジンのドライバーを取得します。
	 * 
	 * @return TM エンジン・ドライバーのインスタンス。
	 */
	public abstract BentenTmDriver getDriver();

	/**
	 * プラグインが保持している TM エンジンのインスタンスを取得します。
	 * 
	 * @return プラグインが保持している TM エンジンのインスタンス。
	 */
	public abstract BentenTmEngine getEngine();

	/**
	 * TM データをロードします。
	 * 
	 * 一般的な処理内容は以下のようになります。
	 * <UL>
	 * <LI>最初にエンジンが保持している TM データをアンロードします。
	 * <LI>拡張ポイント登録一覧から、この TM エンジンが処理可能な拡張ポイントを取得します。
	 * <LI>得られた拡張ポイントから処理可能な拡張のリストを取得します。
	 * <LI>拡張のリストの中で、この TM エンジンが期待する名称の拡張を取得します。
	 * <LI>得られた拡張から、TMX データを読み込みます。
	 * </UL>
	 */
	public abstract void load();
}
