/*******************************************************************************
 benten.cat.tm.engine.omegat - Benten default TM
                               (Translation Memory) engine.
 Copyright (C) 2009 Information-technology Promotion Agency, Japan.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, see <http://www.gnu.org/licenses>.
 *******************************************************************************/
package benten.cat.tm.engine.omegat.ui;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.omegat.util.StaticUtils;
import org.osgi.framework.BundleContext;

import benten.cat.tm.core.BentenTmDriver;
import benten.cat.tm.core.BentenTmDriverManager;
import benten.cat.tm.core.BentenTmEngine;
import benten.cat.tm.data.AbstractBentenTmDataTmxPlugin;
import benten.cat.tm.engine.AbstractBentenTmEnginePlugin;
import benten.cat.tm.engine.omegat.DefaultTmDriver;
import benten.cat.tm.engine.omegat.ui.messages.BentenTmPluginMessages;
import benten.ui.preference.BentenPreference;
import benten.ui.preference.BentenPreference.Preference;

/**
 * デフォルトの Benten TM (翻訳メモリー) エンジン・プラグイン。
 *
 * <UL>
 * <LI>このプラグインを Eclipse 上で有効化するためのプラグイン・クラスです。
 * </UL>
 *
 * ★基本設計「共通機能: 翻訳メモリー・エンジン機能」に対応します。
 * 
 * @author YAMAMOTO Koji
 */
public class BentenTmPlugin extends AbstractBentenTmEnginePlugin {
	/** 共用インスタンス。 */
	private static BentenTmPlugin plugin;

	/**
	 * Benten デフォルト TM エンジン・プラグインのためのメッセージ。
	 */
	protected static final BentenTmPluginMessages fMsg = new BentenTmPluginMessages();

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	@Override
	public AbstractBentenTmEnginePlugin getPluginDefault() {
		return plugin;
	}

	@Override
	public BentenTmDriver getDriver() {
		try {
			// 自らのドライバーを自己登録します。
			Class.forName("benten.cat.tm.engine.omegat.DefaultTmDriver"); //$NON-NLS-1$
		} catch (final ClassNotFoundException e) {
			log(fMsg.getGetDriverClassNotFoundException());
			log(e);
		}

		return BentenTmDriverManager.getDriver(DefaultTmDriver.DRIVER_NAME);
	}

	@Override
	public BentenTmEngine getEngine() {
		if (fEngine == null) {
			fEngine = getDriver().getEngineInstance();
		}

		return fEngine;
	}

	@Override
	public void load() {
		getPluginDefault().log(fMsg.getLoadI001());

		getEngine().unload();

		// OmegaT 専用の特殊対応。
		final File dummyOmegatPrefs = new File(StaticUtils.getConfigDir() + "omegat.prefs"); //$NON-NLS-1$
		if (!dummyOmegatPrefs.exists()) {
			try {
				final PrintWriter writer = new PrintWriter(dummyOmegatPrefs);
				writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"); //$NON-NLS-1$
				writer.close();
			} catch (final IOException e) {
				getPluginDefault().log(e);
			}
		}

		for (File dir : getTmxDir()) {
			try {
				getEngine().loadTmx(dir);
			} catch (final IOException e) {
				getPluginDefault().log(e);
			}
		}
	}

	/**
	 * 拡張ポイントなどから TMX ディレクトリーを取得します。
	 * @return TMX ディレクトリー。必ず null 以外が戻ります。
	 */
	private File[] getTmxDir() {
		final List<File> result = new ArrayList<File>();

		final IPreferenceStore store = BentenPreference.getStore();
		final boolean useTmxLocation = store.getBoolean(Preference.USE_TMX_LOCATION.name());
		if (useTmxLocation) {
			final String tmxFolder = store.getString(Preference.TMX_LOCATION.name());
			final File dir = new File(tmxFolder);
			result.add(dir);
			getPluginDefault().log(fMsg.getGetTmxDirI001(dir.getAbsolutePath()));
		} else {
			for (AbstractBentenTmDataTmxPlugin plugin : getTmxDataPlugin()) {
				final File dir = plugin.getPluginDefault().getFile("/tmx"); //$NON-NLS-1$
				result.add(dir);
				getPluginDefault().log(fMsg.getGetTmxDirI001(dir.getAbsolutePath()));
			}
		}

		for (File dir : result) {
			if (dir.exists() == false) {
				throw new IllegalArgumentException(fMsg.getGetTmxDirE001(dir.getAbsolutePath()));
			}
			if (dir.isDirectory() == false) {
				throw new IllegalArgumentException(fMsg.getGetTmxDirE002(dir.getAbsolutePath()));
			}
		}

		return result.toArray(new File[result.size()]);
	}

	/**
	 * 拡張ポイントから TM データ TMX プラグインを取得します。
	 * @return TM データ TMX プラグイン。必ず null 以外が戻ります。
	 */
	private List<AbstractBentenTmDataTmxPlugin> getTmxDataPlugin() {
		final List<AbstractBentenTmDataTmxPlugin> result = new ArrayList<AbstractBentenTmDataTmxPlugin>();

		final IExtensionRegistry registry = Platform.getExtensionRegistry();
		final IExtensionPoint point = registry.getExtensionPoint("benten.cat.tm.data.tmx"); //$NON-NLS-1$

		if (point == null) {
			throw new IllegalArgumentException(fMsg.getGetTmxDataPluginE001());
		}

		for (IExtension extension : point.getExtensions()) {
			for (IConfigurationElement cfgElem : extension.getConfigurationElements()) {
				try {
					final Object tmxPluginClass = cfgElem.createExecutableExtension("class"); //$NON-NLS-1$
					if (tmxPluginClass instanceof AbstractBentenTmDataTmxPlugin) {
						result.add((AbstractBentenTmDataTmxPlugin) tmxPluginClass);
					}
				} catch (final CoreException e) {
					getPluginDefault().log(e);
				}
			}
		}
		return result;
	}
}
