/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.ui;

import junit.framework.TestCase;

public class CatTmUiPluginTest extends TestCase {

	private final CatTmUiPlugin plugin = CatTmUiPlugin.getDefault();

	public void testLoadExtensions() {
		plugin.loadExtensions();
		assertTrue(true);
	}

	public void testFuzzyMatch() {
		assertTrue(plugin.fuzzyMatch(null).size() == 0);
		assertTrue(plugin.fuzzyMatch("").size() == 0);
		assertNotNull(plugin.fuzzyMatch("test"));
	}

	public void testGetTmEngine() {
		assertNotNull(plugin.getTmEngine());
	}

	public void testNewTmEnginePluginInstance() {
		assertNotNull(plugin.newTmEnginePluginInstance());
	}

	public void testGetTmEnginePluginNameSet() {
		assertTrue(plugin.getTmEnginePluginNameSet().size() > 0);
	}
}
