/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.ui.actions;

import junit.framework.TestCase;

import org.eclipse.jface.viewers.StructuredSelection;

import benten.cat.tm.core.BentenTmSearchResult;

public class CopyTranslationTargetActionTest extends TestCase {

	private StructuredSelection selection(final String text) {
		final BentenTmSearchResult result = new BentenTmSearchResult();
		result.setTarget(text);
		final StructuredSelection selection = new StructuredSelection(result);
		return selection;
	}

	public void testAsText() {
		final CopyTranslationTargetAction action = new CopyTranslationTargetAction(null, null);
		try {
			action.asText(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		assertEquals(null, action.asText(selection(null)));
		assertEquals("", action.asText(selection("")));
		assertEquals("test", action.asText(selection("test")));
	}
}
