/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.ui.views;

import junit.framework.TestCase;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.PartInitException;

import benten.cat.tm.core.BentenTmSearchResult;
import benten.cat.tm.ui.views.TranslationView.TmMatchQualitySortListener;
import benten.cat.tm.ui.views.TranslationView.TmOriginSortListener;
import benten.cat.tm.ui.views.TranslationView.TmSourceSortListener;
import benten.cat.tm.ui.views.TranslationView.TmTargetSortListener;
import benten.ui.UiPlugin;
import benten.ui.views.TableColumnSortAdapter;
import benten.ui.views.TableColumnSortAdapter.TableColumnSorter;

public class TranslationViewTest extends TestCase {

	final TranslationView view = new TranslationView() {
		@Override
		protected void createContextMenu() {
		}
	};

	@SuppressWarnings("unchecked")
	private TableColumnSortAdapter<BentenTmSearchResult> getListener(final int columnIndex) {
		final Table table = view.getTableViewer().getTable();
		final Listener listener = table.getColumn(columnIndex).getListeners(SWT.Selection)[0];
		return (TableColumnSortAdapter<BentenTmSearchResult>) ((TypedListener) listener).getEventListener();
	}

	private BentenTmSearchResult createModel(final String m, final String o, final String s, final String t) {
		final BentenTmSearchResult model = new BentenTmSearchResult();
		model.setMatchQuality(m);
		model.setOrigin(o);
		model.setSource(s);
		model.setTarget(t);
		return model;
	}

	public void testCreateTableViewer() throws PartInitException {
		view.createPartControl(UiPlugin.getShell());
		final Table table = view.getTableViewer().getTable();

		assertEquals(4, table.getColumnCount());

		assertTrue(getListener(0) instanceof TmOriginSortListener);
		assertTrue(getListener(1) instanceof TmMatchQualitySortListener);
		assertTrue(getListener(2) instanceof TmSourceSortListener);
		assertTrue(getListener(3) instanceof TmTargetSortListener);

		assertEquals(0, getListener(0).getColumnIndex());
		assertEquals(1, getListener(1).getColumnIndex());
		assertEquals(2, getListener(2).getColumnIndex());
		assertEquals(3, getListener(3).getColumnIndex());

		final BentenTmSearchResult model1 = createModel("m1", "o2", "s1", "t2");
		final BentenTmSearchResult model2 = createModel("m2", "o1", "s2", "t1");
		TableColumnSorter<BentenTmSearchResult> sorter = null;

		sorter = getListener(0).createTableColumnSorter();
		assertTrue(sorter.compare(model1, model1) == 0);
		assertTrue(sorter.compare(model1, model2) > 0);
		assertTrue(sorter.compare(model2, model1) < 0);

		sorter = getListener(1).createTableColumnSorter();
		assertTrue(sorter.compare(model1, model1) == 0);
		assertTrue(sorter.compare(model1, model2) < 0);
		assertTrue(sorter.compare(model2, model1) > 0);

		sorter = getListener(2).createTableColumnSorter();
		assertTrue(sorter.compare(model1, model1) == 0);
		assertTrue(sorter.compare(model1, model2) < 0);
		assertTrue(sorter.compare(model2, model1) > 0);

		sorter = getListener(3).createTableColumnSorter();
		assertTrue(sorter.compare(model1, model1) == 0);
		assertTrue(sorter.compare(model1, model2) > 0);
		assertTrue(sorter.compare(model2, model1) < 0);
	}
}
