/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.ui.internal.tabletree.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * マルチエディタパートのためのメッセージ。
 *
 * リソースバンドル定義: [XLIFFMultiPageEditorPartMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class XLIFFMultiPageEditorPartMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * XLIFFMultiPageEditorPartMessagesクラスのコンストラクタ。
     *
     * 基底名[XLIFFMultiPageEditorPartMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public XLIFFMultiPageEditorPartMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/internal/tabletree/messages/XLIFFMultiPageEditorPartMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * XLIFFMultiPageEditorPartMessagesクラスのコンストラクタ。
     *
     * 基底名[XLIFFMultiPageEditorPartMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public XLIFFMultiPageEditorPartMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/internal/tabletree/messages/XLIFFMultiPageEditorPartMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * XLIFFMultiPageEditorPartMessagesクラスのコンストラクタ。
     *
     * 基底名[XLIFFMultiPageEditorPartMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public XLIFFMultiPageEditorPartMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/internal/tabletree/messages/XLIFFMultiPageEditorPartMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[XLIFFMultiPageEditorPartMessages], key[JobName]
     *
     * [Saving XLIFF...] (en)<br>
     * [XLIFF の保管中...] (ja)<br>
     *
     * @return key[JobName]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getJobName() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Saving XLIFF...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("JobName");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
