/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.runtime.preferences.IEclipsePreferences.IPreferenceChangeListener;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.BundleContext;

import benten.ui.AbstractBentenUiPlugin;

/**
 * Cat UI プラグイン。
 *
 * <UL>
 * <LI>このプラグインを Eclipse 上で有効化するためのプラグイン・クラスです。
 * </UL>
 *
 * ★基本設計「翻訳支援機能: 翻訳中間形式エディター機能: 翻訳中間形式(XLIFF)エディターの起動」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public class CatUiPlugin extends AbstractBentenUiPlugin {

	/** 共用インスタンス */
	private static CatUiPlugin plugin;

	/** アクティブなエディター・パーツ。 */
	private IEditorPart activeEditorPart;

	/** 設定変更リスナー。 */
	private final List<IPreferenceChangeListener> preferenceChangeListners = new LinkedList<IPreferenceChangeListener>();

	/** Cat Ui 設定 enum */
	public static enum CatUiPreference {
		SHOW_LINE_BREAK
	}

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * このプラグインの共用インスタンスを取得。
	 * @return このプラグインの共用インスタンス
	 */
	public static CatUiPlugin getDefault() {
		return plugin;
	}

	/**
	 * アクティブなエディター・パーツの取得。
	 * @return アクティブなエディター・パーツ
	 */
	public IEditorPart getActiveEditorPart() {
		return activeEditorPart;
	}

	/**
	 * アクティブなエディター・パーツのセット。
	 * @param activeEditorPart アクティブなエディター・パーツ
	 */
	public void setActiveEditorPart(final IEditorPart activeEditorPart) {
		this.activeEditorPart = activeEditorPart;
	}

	/**
	 * 設定変更の通知。
	 */
	public void firePreferenceChange() {
		for (final IPreferenceChangeListener listener : preferenceChangeListners) {
			listener.preferenceChange(null);
		}
	}

	/**
	 * 設定変更リスナーの追加。
	 * @param listner 設定変更リスナー
	 */
	public void addPreferenceChangeListner(final IPreferenceChangeListener listner) {
		preferenceChangeListners.add(listner);
	}

	/**
	 * 設定変更リスナーの除去。
	 * @param listner 設定変更リスナー
	 */
	public void removePreferenceChangeListner(final IPreferenceChangeListener listner) {
		preferenceChangeListners.remove(listner);
	}
}
