/*****************************************************************************
 * Copyright (c) 2004, 2007 IBM Corporation and others. All rights reserved. This
 * program and the accompanying materials are made available under the terms
 * of the Eclipse Public License v1.0 which accompanies this distribution, and
 * is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: IBM Corporation - initial API and implementation
 ****************************************************************************/
/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.internal.tabletree;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.regions.DOMRegionContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/**
 * XLIFF 選択プロバイダー。
 *
 * <UL>
 * <LI>このクラスは {@link org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeViewer}
 * のインナークラス SelectionProvider 由来のものです。
 * <LI>翻訳単位タブとソース・タブとの選択連携を実現します。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public class XLIFFSelectionProvider implements IPostSelectionProvider {

	/** ビューアー */
	private final Viewer viewer;

	/**
	 * コンストラクター。
	 * @param viewer ビューアー
	 */
	public XLIFFSelectionProvider(final Viewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * {@inheritDoc}
	 */
	public void addPostSelectionChangedListener(final ISelectionChangedListener listener) {
		// 何もしない
		//viewer.this.addPostSelectionChangedListener(listener);
	}

	/**
	 * {@inheritDoc}
	 */
	public void removePostSelectionChangedListener(final ISelectionChangedListener listener) {
		// 何もしない
		//viewer.this.removePostSelectionChangedListener(listener);
	}

	/**
	 * {@inheritDoc}
	 */
	public void addSelectionChangedListener(final ISelectionChangedListener listener) {
		viewer.addSelectionChangedListener(listener);
	}

	/**
	 * {@inheritDoc}
	 */
	public ISelection getSelection() {
		return viewer.getSelection();
	}

	/**
	 * {@inheritDoc}
	 */
	public void removeSelectionChangedListener(final ISelectionChangedListener listener) {
		viewer.removeSelectionChangedListener(listener);
	}

	/**
	 * {@inheritDoc}
	 */
	public void setSelection(final ISelection selection) {
		boolean selectionSet = false;
		if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
			final IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			if (selection instanceof ITextSelection) {
				final ITextSelection textSelection = (ITextSelection) selection;

				if (structuredSelection.size() == 1) {
					if (structuredSelection.getFirstElement() instanceof IDOMNode) {
						final IDOMNode domNode = (IDOMNode) structuredSelection.getFirstElement();
						final IStructuredDocumentRegion startStructuredDocumentRegion = domNode
								.getStartStructuredDocumentRegion();
						if (startStructuredDocumentRegion != null) {
							ITextRegion matchingRegion = startStructuredDocumentRegion
									.getRegionAtCharacterOffset(textSelection.getOffset());
							int allowedIterations = 40;
							while (matchingRegion != null
									&& !matchingRegion.getType().equals(DOMRegionContext.XML_TAG_ATTRIBUTE_NAME)
									&& allowedIterations > 0) {
								matchingRegion = startStructuredDocumentRegion
										.getRegionAtCharacterOffset(startStructuredDocumentRegion
												.getStartOffset(matchingRegion) - 1);
								allowedIterations--;
							}
							if (matchingRegion != null
									&& matchingRegion.getType().equals(DOMRegionContext.XML_TAG_ATTRIBUTE_NAME)) {
								final String attrName = startStructuredDocumentRegion.getText(matchingRegion);
								final NamedNodeMap attributes = domNode.getAttributes();
								if (attributes != null && attrName.length() > 0) {
									final Node attr = attributes.getNamedItem(attrName);
									if (attr != null) {
										selectionSet = true;
										viewer.setSelection(new StructuredSelection(attr));
									}
								}
							}
						}
					}
				}
			}
		}
		if (!selectionSet) {
			viewer.setSelection(selection);
		}
	}
}
