/*******************************************************************************
 * Copyright (c) 2010  NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.viewers;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

import benten.cat.ui.viewers.TransCompareViewer.TransDiffContent;

/**
 * 翻訳比較ビューアーのコンテンツ・プロバイダー。
 *
 * @author KASHIHARA Shinji
 */
class TransCompareContentProvider implements IMergeViewerContentProvider {

	// 比較構成。
	private final CompareConfiguration fCompareConfiguration;

	// 左ラベル。
	private final String leftLabel;

	// 右ラベル。
	private final String rightLabel;

	// 左編集可不可。
	private boolean leftEditable;

	/**
	 * コンストラクター。
	 * @param cc 比較構成。
	 * @param leftLabel 左ラベル。
	 * @param rightLabel 右ラベル。
	 */
	public TransCompareContentProvider(final CompareConfiguration cc, final String leftLabel, final String rightLabel) {
		fCompareConfiguration = cc;
		this.leftLabel = leftLabel;
		this.rightLabel = rightLabel;
	}

	/**
	 * 左コンテンツの編集可不可を設定。
	 * @param editable 編集可能にする場合は true。
	 */
	protected void setLeftEditable(final boolean editable) {
		leftEditable = editable;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getAncestorLabel(final Object input) {
		return fCompareConfiguration.getAncestorLabel(input);
	}

	/**
	 * {@inheritDoc}
	 */
	public Image getAncestorImage(final Object input) {
		return fCompareConfiguration.getAncestorImage(input);
	}

	/**
	 * {@inheritDoc}
	 */
	public Object getAncestorContent(final Object input) {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean showAncestor(final Object input) {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getLeftLabel(final Object input) {
		return leftLabel;
	}

	/**
	 * {@inheritDoc}
	 */
	public Image getLeftImage(final Object input) {
		return fCompareConfiguration.getLeftImage(input);
	}

	/**
	 * {@inheritDoc}
	 */
	public Object getLeftContent(final Object input) {
		if (input instanceof TransDiffContent) {
			return new Document(((TransDiffContent) input).left);
		}
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isLeftEditable(final Object input) {
		return leftEditable;
	}

	/**
	 * {@inheritDoc}
	 */
	public void saveLeftContent(final Object input, final byte[] bytes) {
	}

	/**
	 * {@inheritDoc}
	 */
	public String getRightLabel(final Object input) {
		return rightLabel;
	}

	/**
	 * {@inheritDoc}
	 */
	public Image getRightImage(final Object input) {
		return fCompareConfiguration.getRightImage(input);
	}

	/**
	 * {@inheritDoc}
	 */
	public Object getRightContent(final Object input) {
		if (input instanceof TransDiffContent) {
			return new Document(((TransDiffContent) input).right);
		}
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isRightEditable(final Object input) {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	public void saveRightContent(final Object input, final byte[] bytes) {
	}

	/**
	 * {@inheritDoc}
	 */
	public void dispose() {
	}

	/**
	 * {@inheritDoc}
	 */
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
	}
}