/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * このフラグメントに含まれるTestCaseをすべて含むTestSuiteです。レポート出力の都合、このクラスのパッケージ名は、ホスト・プラグインのidにあわせるようにします。
 */
public class AllTests {
	/**
	 * TestSuiteです。
	 *
	 * @return benten.core.testフラグメントに含まれるTestCaseを含むTestSuiteを返します
	 */
	public static Test suite() {
		TestSuite suite = new TestSuite("Test for benten.core");
		suite.addTestSuite(benten.core.dom.TransUnitDelegateTest.class);
		suite.addTestSuite(benten.core.io.FilesTest.class);
		suite.addTestSuite(benten.core.io.IniFileTest.class);
		suite.addTestSuite(benten.core.io.ResourceFileTest.class);
		suite.addTestSuite(benten.core.io.TmxFileFilterTest.class);
		suite.addTestSuite(benten.core.io.XliffFileFilterTest.class);
		suite.addTestSuite(benten.core.model.HelpTransUnitIdTest.class);
		suite.addTestSuite(benten.core.text.StringsTest.class);
		return suite;
	}
}
