/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.io;

import java.io.File;

import junit.framework.TestCase;

public class FilesTest extends TestCase {

	public void testBaseName() {
		try {
			Files.baseName(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		assertEquals("", Files.baseName(new File("")));
		assertEquals("abc", Files.baseName(new File("abc")));
		assertEquals("abc", Files.baseName(new File("abc.html")));
		assertEquals("abc.html", Files.baseName(new File("abc.html.xlf")));
	}
}
