/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.io;

import java.io.IOException;
import java.util.List;

import junit.framework.TestCase;

public class IniFileTest extends TestCase {

	public void testAsList() throws IOException {
		StringBuilder sb = new StringBuilder();
		List<String> list = new IniFile().createList(sb.toString());
		assertEquals(0, list.size());

		sb = new StringBuilder();
		sb.append("a\n");
		sb.append("b\n");
		sb.append("c\n");
		list = new IniFile().createList(sb.toString());
		assertEquals(3, list.size());
		assertEquals("a", list.remove(0));
		assertEquals("b", list.remove(0));
		assertEquals("c", list.remove(0));

		sb = new StringBuilder();
		sb.append("a\r\n");
		sb.append("b\n");
		sb.append("c\n");
		list = new IniFile().createList(sb.toString());
		assertEquals(3, list.size());
		assertEquals("a", list.remove(0));
		assertEquals("b", list.remove(0));
		assertEquals("c", list.remove(0));

		sb = new StringBuilder();
		sb.append("#comment\n");
		sb.append("aaa\n");
		sb.append("bbb\n");
		sb.append("ccc\n");
		list = new IniFile().createList(sb.toString());
		assertEquals(3, list.size());
		assertEquals("aaa", list.remove(0));
		assertEquals("bbb", list.remove(0));
		assertEquals("ccc", list.remove(0));
	}
}
