/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.io;

import java.io.File;

import junit.framework.TestCase;

public class TmxFileFilterTest extends TestCase {

	public void testAccept() {
		try {
			TmxFileFilter.INSTANCE.accept(null, null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		assertEquals(true, TmxFileFilter.INSTANCE.accept(null, "abc.tmx"));
		assertEquals(true, TmxFileFilter.INSTANCE.accept(null, "abc.xyz.tmx"));
		assertEquals(false, TmxFileFilter.INSTANCE.accept(null, "abctmx"));
		assertEquals(false, TmxFileFilter.INSTANCE.accept(null, ""));
	}

	public void testAppendExtension() {
		assertEquals("null.tmx", TmxFileFilter.appendExtension(null).getPath());
		assertEquals("abc.html.tmx", TmxFileFilter.appendExtension(new File("abc.html")).getPath());
		assertEquals("abc.tmx", TmxFileFilter.appendExtension(new File("abc")).getPath());
		assertEquals(".tmx", TmxFileFilter.appendExtension(new File("")).getPath());
	}
}
