package benten.core.io;

import java.io.File;

import junit.framework.TestCase;

public class XliffFileFilterTest extends TestCase {

	public void testAccept() {
		try {
			XliffFileFilter.INSTANCE.accept(null, null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		assertEquals(true, XliffFileFilter.INSTANCE.accept(null, "abc.xlf"));
		assertEquals(true, XliffFileFilter.INSTANCE.accept(null, "abc.xyz.xlf"));
		assertEquals(false, XliffFileFilter.INSTANCE.accept(null, "abcxlf"));
		assertEquals(false, XliffFileFilter.INSTANCE.accept(null, ""));
	}

	public void testAppendExtension() {
		assertEquals("null.xlf", XliffFileFilter.appendExtension(null).getPath());
		assertEquals("abc.html.xlf", XliffFileFilter.appendExtension(new File("abc.html")).getPath());
		assertEquals("abc.xlf", XliffFileFilter.appendExtension(new File("abc")).getPath());
		assertEquals(".xlf", XliffFileFilter.appendExtension(new File("")).getPath());
	}
}
