/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.dom;

import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;

/**
 * XLIFF の note 要素です。
 *
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public class NoteDelegate extends ElementDelegate {

	/**
	 * コンストラクター。
	 * @param domDocument dom ドキュメント
	 * @param element 要素
	 */
	public NoteDelegate(final IDOMDocument domDocument, final Element element) {
		super(domDocument, element);
	}

	/**
	 * from 属性の取得。
	 * @return from 属性の値
	 */
	public String getFrom() {
		return getValue("@from"); //$NON-NLS-1$
	}

	/**
	 * from 属性のセット。
	 * @param from from 属性の値
	 * @return 変更があった場合は true
	 */
	public boolean setFrom(final String from) {
		return setValue("@from", from); //$NON-NLS-1$
	}
}
