/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.dom;

import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * XLIFF の trans-unit、alt-trans 共通要素です。
 *
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public abstract class TransBaseDelegate extends ElementDelegate {

	/**
	 * コンストラクター。
	 * @param domDocument dom ドキュメント
	 * @param element 要素
	 */
	public TransBaseDelegate(final IDOMDocument domDocument, final Element element) {
		super(domDocument, element);
	}

	/**
	 * source 要素の値を取得。
	 * @return source 要素の値
	 */
	public String getSource() {
		return getValue("source"); //$NON-NLS-1$
	}

	/**
	 * target 要素の値を取得。
	 * @return target 要素の値
	 */
	public String getTarget() {
		return getValue("target"); //$NON-NLS-1$
	}

	/**
	 * source ノードの取得。
	 * @return source ノード
	 */
	public Node getSourceNode() {
		return getChildElement("source"); //$NON-NLS-1$
	}

	/**
	 * target ノードの取得。
	 * @return target ノード
	 */
	public Node getTargetNode() {
		return getChildElement("target"); //$NON-NLS-1$
	}
}
