/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.core;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import junit.framework.TestCase;
import benten.cat.tm.core.BentenTmEngine;
import benten.cat.tm.core.BentenTmSearchResult;
import benten.twa.cat.core.valueobject.BentenApplyExactMatchProcessInput;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BentenApplyExactMatchProcessImplTest extends TestCase {

	BentenTmEngine tmEngineStub = new BentenTmEngine() {
		public void setLang(final String source, final String target) {
		}

		public List<BentenTmSearchResult> fuzzySearch(final String search) {
			final BentenTmSearchResult result = new BentenTmSearchResult();
			result.setSource("hello Benten");
			result.setTarget("こんにちは Benten");
			final List<BentenTmSearchResult> list = new LinkedList<BentenTmSearchResult>();
			list.add(result);
			return list;
		}

		public void loadTmx(final File dirTmx) throws IOException {
		}

		public void unload() {
		}
	};

	public void testProcessTransUnit0001() {

		final BentenApplyExactMatchProcessImpl process = new BentenApplyExactMatchProcessImpl();
		final BentenApplyExactMatchProcessInput input = new BentenApplyExactMatchProcessInput();
		process.setInput(input);
		process.fTm = tmEngineStub;

		// Null
		try {
			process.processTransUnit(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}

		// 一致なし
		final BlancoXliffTransUnit transUnit = new BlancoXliffTransUnit();
		transUnit.setSource("xxx");
		process.processTransUnit(transUnit);
		assertEquals(0, process.getResultInfo().getUnitCount());
		assertEquals(null, transUnit.getTarget());
	}

	public void testProcessTransUnit0002() {

		final BentenApplyExactMatchProcessImpl process = new BentenApplyExactMatchProcessImpl();
		final BentenApplyExactMatchProcessInput input = new BentenApplyExactMatchProcessInput();
		process.setInput(input);
		process.fTm = tmEngineStub;

		// 一致あり
		final BlancoXliffTransUnit transUnit = new BlancoXliffTransUnit();
		transUnit.setSource("hello Benten");
		process.processTransUnit(transUnit);
		assertEquals(1, process.getResultInfo().getUnitCount());
		assertEquals("こんにちは Benten", transUnit.getTarget().getTarget());
		assertEquals("translated", transUnit.getTarget().getState());
	}

	public void testProcessTransUnit0003() {

		final BentenApplyExactMatchProcessImpl process = new BentenApplyExactMatchProcessImpl();
		final BentenApplyExactMatchProcessInput input = new BentenApplyExactMatchProcessInput();
		process.setInput(input);
		process.fTm = tmEngineStub;

		// 一致あり (ホワイトスペース除去 OFF)
		final BlancoXliffTransUnit transUnit = new BlancoXliffTransUnit();
		transUnit.setSource(" hello\r\n\tBenten");
		process.processTransUnit(transUnit);
		assertEquals(0, process.getResultInfo().getUnitCount());
		assertEquals(null, transUnit.getTarget());
	}

	public void testProcessTransUnit0004() {

		final BentenApplyExactMatchProcessImpl process = new BentenApplyExactMatchProcessImpl();
		final BentenApplyExactMatchProcessInput input = new BentenApplyExactMatchProcessInput();
		process.setInput(input);
		process.fTm = tmEngineStub;

		// 一致あり (ホワイトスペース除去 ON)
		input.setIgnorewhitespacetmreference(true);
		final BlancoXliffTransUnit transUnit = new BlancoXliffTransUnit();
		transUnit.setSource(" hello\r\n\tBenten");
		process.processTransUnit(transUnit);
		assertEquals(1, process.getResultInfo().getUnitCount());
		assertEquals("こんにちは Benten", transUnit.getTarget().getTarget());
		assertEquals("translated", transUnit.getTarget().getState());
	}
}
