/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.core;

import junit.framework.TestCase;

public class BentenMarkNoTransableProcessImplTest extends TestCase {

	private final BentenMarkNoTransableProcessImpl target = new BentenMarkNoTransableProcessImpl();

	public void testCheckNoTransableString() {

		assertEquals("x", true, target.checkNoTransableString(null));
		assertEquals("x", true, target.checkNoTransableString(""));
		assertEquals("x", true, target.checkNoTransableString("null"));

		assertEquals("o", false, target.checkNoTransableString("translate"));
		assertEquals("o", false, target.checkNoTransableString("translate."));
		assertEquals("o", false, target.checkNoTransableString("must translate"));
		assertEquals("o", false, target.checkNoTransableString("to"));
		assertEquals("x", true, target.checkNoTransableString("t"));

		assertEquals("x", true, target.checkNoTransableString("1"));
		assertEquals("x", true, target.checkNoTransableString("12"));
		assertEquals("x", true, target.checkNoTransableString("1.2"));
		assertEquals("x", true, target.checkNoTransableString("v1.2"));
		assertEquals("o", false, target.checkNoTransableString("v1.2x"));
		assertEquals("o", false, target.checkNoTransableString("v1.x2"));
		assertEquals("o", false, target.checkNoTransableString("Version1.2"));

		assertEquals("x", true, target.checkNoTransableString("{0}"));
		assertEquals("x", true, target.checkNoTransableString("{0}."));
		assertEquals("x", true, target.checkNoTransableString("{0}:"));

		assertEquals("x", true, target.checkNoTransableString("org.eclipse"));
		assertEquals("x", true, target.checkNoTransableString("org.eclipse.Test"));
		assertEquals("o", false, target.checkNoTransableString("org.eclipse.Test."));

		assertEquals("o", false, target.checkNoTransableString("日本語"));
		assertEquals("o", false, target.checkNoTransableString("日本語 t"));
		assertEquals("o", false, target.checkNoTransableString("日本語 translate"));
		assertEquals("o", false, target.checkNoTransableString("null。"));
	}
}
