package benten.twa.cat.dialogs;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;

import junit.framework.TestCase;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.twa.cat.dialogs.MarkNoTransableDialog.MarkNoTransableControls;
import benten.twa.ui.wizards.NewProjectCreationWizard;
import benten.ui.UiStatusException;
import benten.ui.fields.AbstractBrowseTextField;
import benten.ui.fields.TextField;

public class MarkNoTransableDialogTest extends TestCase {

	private final MarkNoTransableDialog target = new MarkNoTransableDialog(null, new StructuredSelection());

	private String getValidateMessage() {
		try {
			target.validate();
			return null;
		} catch (final UiStatusException e) {
			return e.getMessage();
		}
	}

	private boolean validate(final TextField field, final String value) {
		AbstractBrowseTextField.clearPreviousInput();
		field.setText(value);
		final String message = getValidateMessage();
		if (message == null) {
			return true;
		}
		return !message.contains(field.getLabelText());
	}

	public void testValidate() throws Exception {

		// テスト対象のダイアログからコントロール・コンテナーの取得
		target.createControls(new Composite(new Shell(), SWT.NONE));
		final Field field = target.getClass().getDeclaredField("controls");
		field.setAccessible(true);
		final MarkNoTransableControls controls = (MarkNoTransableControls) field.get(target);

		// ワークスペースにテスト用のプロジェクトを作成
		final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		final IProject project = root.getProject("test.project");
		new NewProjectCreationWizard().createProject(project);
		final IFile file = project.getFile(new Path("test.file"));
		if (!file.exists()) {
			file.create(new ByteArrayInputStream("".getBytes()), true, null);
		}

		assertFalse(validate(controls.targetDirText, null));
		assertFalse(validate(controls.targetDirText, ""));
		assertFalse(validate(controls.targetDirText, ".先頭ピリオド"));
		assertFalse(validate(controls.targetDirText, "末尾ピリオド."));
		assertFalse(validate(controls.targetDirText, "存在しないリソース"));
		assertFalse(validate(controls.targetDirText, "test.file"));
		assertTrue(validate(controls.targetDirText, "/test.project/.benten/source"));

		assertNull(getValidateMessage());
	}
}
