/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.cat.core;

import java.io.IOException;

import benten.twa.cat.core.valueobject.BentenApplyFuzzyMatchProcessInput;

/**
 * 処理 [BentenApplyFuzzyMatchProcess]インタフェース。
 *
 * このインタフェースを継承して [benten.twa.cat.core]パッケージに[BentenApplyFuzzyMatchProcess]クラスを作成して実際のバッチ処理を実装してください。<br>
 */
interface BentenApplyFuzzyMatchProcess {
    /**
     * クラスをインスタンス化して処理を実行する際のエントリポイントです。
     *
     * @param input 処理の入力パラメータ。
     * @return 処理の実行結果。
     * @throws IOException 入出力例外が発生した場合。
     * @throws IllegalArgumentException 入力値に不正が見つかった場合。
     */
    int execute(final BentenApplyFuzzyMatchProcessInput input) throws IOException, IllegalArgumentException;

    /**
     * 処理の中でアイテムが処理されるたびに進捗報告としてコールバックします。
     *
     * @param argProgressMessage 現在処理しているアイテムに関するメッセージ。
     * @return 処理をそのまま継続する場合は false。処理中断をリクエストしたい場合は true。
     */
    boolean progress(final String argProgressMessage);
}
