/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.converter.tmx.valueobject;

/**
 * 処理クラス [BentenConverterTmxAdjusterProcess]の入力バリューオブジェクトクラスです。
 */
public class BentenConverterTmxAdjusterProcessInput {
    /**
     * verboseモードで動作させるかどうか。
     *
     * フィールド: [verbose]。
     * デフォルト: [false]。
     */
    private boolean fVerbose = false;

    /**
     * 入力となる TMX が格納されているディレクトリ。
     *
     * フィールド: [sourcedir]。
     */
    private String fSourcedir;

    /**
     * 出力となる TMX が格納されているディレクトリ。
     *
     * フィールド: [targetdir]。
     */
    private String fTargetdir;

    /**
     * ホワイトスペースを無視した内容の TMX を抽出するかどうか。HTML の場合には true を推奨。
     *
     * フィールド: [ignorewhitespacetmxconvert]。
     * デフォルト: [false]。
     */
    private boolean fIgnorewhitespacetmxconvert = false;

    /**
     * Unicode の a0 を &amp;amp;nbsp; に変換するかどうか。HTML の場合には true を推奨。
     *
     * フィールド: [convertcharnbsp]。
     * デフォルト: [false]。
     */
    private boolean fConvertcharnbsp = false;

    /**
     * フィールド [verbose] の値を設定します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     *
     * @param argVerbose フィールド[verbose]に設定する値。
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * フィールド [verbose] の値を取得します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[verbose]から取得した値。
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * フィールド [sourcedir] の値を設定します。
     *
     * フィールドの説明: [入力となる TMX が格納されているディレクトリ。]。
     *
     * @param argSourcedir フィールド[sourcedir]に設定する値。
     */
    public void setSourcedir(final String argSourcedir) {
        fSourcedir = argSourcedir;
    }

    /**
     * フィールド [sourcedir] の値を取得します。
     *
     * フィールドの説明: [入力となる TMX が格納されているディレクトリ。]。
     *
     * @return フィールド[sourcedir]から取得した値。
     */
    public String getSourcedir() {
        return fSourcedir;
    }

    /**
     * フィールド [targetdir] の値を設定します。
     *
     * フィールドの説明: [出力となる TMX が格納されているディレクトリ。]。
     *
     * @param argTargetdir フィールド[targetdir]に設定する値。
     */
    public void setTargetdir(final String argTargetdir) {
        fTargetdir = argTargetdir;
    }

    /**
     * フィールド [targetdir] の値を取得します。
     *
     * フィールドの説明: [出力となる TMX が格納されているディレクトリ。]。
     *
     * @return フィールド[targetdir]から取得した値。
     */
    public String getTargetdir() {
        return fTargetdir;
    }

    /**
     * フィールド [ignorewhitespacetmxconvert] の値を設定します。
     *
     * フィールドの説明: [ホワイトスペースを無視した内容の TMX を抽出するかどうか。HTML の場合には true を推奨。]。
     *
     * @param argIgnorewhitespacetmxconvert フィールド[ignorewhitespacetmxconvert]に設定する値。
     */
    public void setIgnorewhitespacetmxconvert(final boolean argIgnorewhitespacetmxconvert) {
        fIgnorewhitespacetmxconvert = argIgnorewhitespacetmxconvert;
    }

    /**
     * フィールド [ignorewhitespacetmxconvert] の値を取得します。
     *
     * フィールドの説明: [ホワイトスペースを無視した内容の TMX を抽出するかどうか。HTML の場合には true を推奨。]。
     * デフォルト: [false]。
     *
     * @return フィールド[ignorewhitespacetmxconvert]から取得した値。
     */
    public boolean getIgnorewhitespacetmxconvert() {
        return fIgnorewhitespacetmxconvert;
    }

    /**
     * フィールド [convertcharnbsp] の値を設定します。
     *
     * フィールドの説明: [Unicode の a0 を &amp;nbsp; に変換するかどうか。HTML の場合には true を推奨。]。
     *
     * @param argConvertcharnbsp フィールド[convertcharnbsp]に設定する値。
     */
    public void setConvertcharnbsp(final boolean argConvertcharnbsp) {
        fConvertcharnbsp = argConvertcharnbsp;
    }

    /**
     * フィールド [convertcharnbsp] の値を取得します。
     *
     * フィールドの説明: [Unicode の a0 を &amp;nbsp; に変換するかどうか。HTML の場合には true を推奨。]。
     * デフォルト: [false]。
     *
     * @return フィールド[convertcharnbsp]から取得した値。
     */
    public boolean getConvertcharnbsp() {
        return fConvertcharnbsp;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.converter.tmx.valueobject.BentenConverterTmxAdjusterProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",sourcedir=" + fSourcedir);
        buf.append(",targetdir=" + fTargetdir);
        buf.append(",ignorewhitespacetmxconvert=" + fIgnorewhitespacetmxconvert);
        buf.append(",convertcharnbsp=" + fConvertcharnbsp);
        buf.append("]");
        return buf.toString();
    }
}
