/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.model;

import junit.framework.TestCase;

public class HtmlBlockMatcherTest extends TestCase {

	public void testGroup() {
		try {
			new HtmlBlockMatcher(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		assertEquals(false, new HtmlBlockMatcher("").find(0));

		assertEquals(true, new HtmlBlockMatcher("<p>test</p>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<div>test</div>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<table>test</table>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<dl>test</dl>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<ul>test</ul>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<ol>test</ol>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<form>test</form>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<address>test</address>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<blockquote>test</blockquote>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<h1>test</h1>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<h2>test</h2>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<h3>test</h3>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<h4>test</h4>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<h5>test</h5>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<h6>test</h6>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<fieldset>test</fieldset>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<hr>test</hr>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<pre>test</pre>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<body>test</body>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<head>test</head>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<meta>test</meta>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<link>test</link>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<script>test</script>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<style>test</style>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<li>test</li>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<title>test</title>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<tr>test</tr>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<th>test</th>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<td>test</td>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<thead>test</thead>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<tbody>test</tbody>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<dt>test</dt>").find(0));
		assertEquals(true, new HtmlBlockMatcher("<dd>test</dd>").find(0));

		assertEquals(true, new HtmlBlockMatcher("<p class=\"aaa\">test</p>").find(0));

		assertEquals(false, new HtmlBlockMatcher("<a>test</a>").find(0));
		assertEquals(false, new HtmlBlockMatcher("<a href=\"aaa\">test</a>").find(0));
		assertEquals(false, new HtmlBlockMatcher("<font>test</font>").find(0));
		assertEquals(false, new HtmlBlockMatcher("<i>test</i>").find(0));

		assertEquals(false, new HtmlBlockMatcher("test").find(0));
		assertEquals(false, new HtmlBlockMatcher("<html>test").find(0));
		assertEquals(false, new HtmlBlockMatcher("<html>test</a>").find(0));
	}

	public void testTrimBlockTag() {
		try {
			HtmlBlockMatcher.trimBlockTag(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		assertEquals("", HtmlBlockMatcher.trimBlockTag(""));
		assertEquals("test", HtmlBlockMatcher.trimBlockTag("<body>test</body>"));
		assertEquals("<a>test</a>", HtmlBlockMatcher.trimBlockTag("<body><a>test</a></body>"));
		assertEquals("<a href=\"aaa\">test</a>", HtmlBlockMatcher.trimBlockTag("<body><a href=\"aaa\">test</a></body>"));
		assertEquals("<i>test</i>", HtmlBlockMatcher.trimBlockTag("<body><i>test</i></body>"));
		assertEquals("<font>test</font>", HtmlBlockMatcher.trimBlockTag("<body><font>test</font></body>"));
		assertEquals("<font>test</font> text", HtmlBlockMatcher.trimBlockTag("<body><font>test</font> text</body>"));
	}
}
